/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.social.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResource;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.domain.social.Flag;
import org.craftercms.social.domain.social.ModerationStatus;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.IllegalUgcException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.exceptions.UGCException;
import org.craftercms.social.repositories.ugc.UGCRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.social.SocialServices;
import org.craftercms.social.services.social.VoteOptions;
import org.craftercms.social.services.social.impl.SocialServicesImpl;
import org.craftercms.social.services.system.TenantConfigurationService;
import org.craftercms.social.services.ugc.pipeline.UgcPipeline;
import org.craftercms.social.util.ebus.SocialEvent;
import org.craftercms.social.util.ebus.UGCEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Reactor;
import reactor.event.Event;

public class SocialServicesImpl<T extends SocialUgc>
implements SocialServices {
    private UGCRepository<T> ugcRepository;
    private Logger log = LoggerFactory.getLogger(SocialServicesImpl.class);
    private Reactor reactor;
    private UgcPipeline pipeline;
    private TenantConfigurationService tenantConfigurationService;
    private ProfileService profileService;

    @HasPermission(action="ugc.voting", type=SocialPermission.class)
    public SocialUgc vote(@ProtectedResource String ugcId, VoteOptions voteOptions, String userId, String contextId) throws SocialException {
        try {
            SocialUgc ugc = (SocialUgc)this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                this.log.debug("Given UGC does not exist with that id {} for that context {}", (Object)ugcId, (Object)contextId);
                throw new IllegalUgcException("Given UGC does not exist for given context");
            }
            switch (1.$SwitchMap$org$craftercms$social$services$social$VoteOptions[voteOptions.ordinal()]) {
                case 1: {
                    this.voteUp(ugc, userId);
                    break;
                }
                case 2: {
                    this.voteDown(ugc, userId);
                    break;
                }
                case 3: {
                    this.unvoteDown(ugc, userId);
                }
                case 4: {
                    this.unvoteUp(ugc, userId);
                }
                default: {
                    this.neutral(ugc, userId);
                }
            }
            this.pipeline.processUgc((UGC)ugc);
            this.ugcRepository.save((Object)ugc);
            this.reactor.notify((Object)UGCEvent.VOTE.getName(), Event.wrap((Object)new SocialEvent((UGC)ugc, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.VOTE)));
            return ugc;
        }
        catch (MongoDataException ex) {
            throw new UGCException("Unable to find UGC with given Id and contextId");
        }
    }

    @HasPermission(action="ugc.flag", type=SocialPermission.class)
    public SocialUgc flag(String ugcId, String contextId, String reason, String userId) throws SocialException {
        this.log.debug("Flagging ugc {} due {}", (Object)ugcId, (Object)reason);
        try {
            SocialUgc ugcToFlag = (SocialUgc)this.ugcRepository.findUGC(contextId, ugcId);
            if (ugcToFlag == null) {
                throw new IllegalUgcException("Given ugc does not belong to given context");
            }
            Flag f = new Flag(reason, userId);
            ugcToFlag.getFlags().add(f);
            this.pipeline.processUgc((UGC)ugcToFlag);
            this.ugcRepository.save((Object)ugcToFlag);
            this.reactor.notify((Object)UGCEvent.FLAG.getName(), Event.wrap((Object)new SocialEvent((UGC)ugcToFlag, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.FLAG)));
            return ugcToFlag;
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to flag ugc " + ugcId, (Throwable)ex);
            throw new SocialException("Unable to flag given ugc", (Throwable)ex);
        }
    }

    public boolean unFlag(String ugcId, String flagId, String userId, String contextId) throws SocialException {
        this.log.debug("Removing flag {} for ugc Id {}", (Object)flagId, (Object)ugcId);
        try {
            SocialUgc ugcToUpdate = (SocialUgc)this.ugcRepository.findUGC(contextId, ugcId);
            if (ugcToUpdate == null) {
                throw new IllegalUgcException("Given ugc does not belong to given context");
            }
            return this.realUnflag(new Flag(new ObjectId(flagId), userId), ugcToUpdate);
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to delete flag " + flagId + " from " + ugcId, (Throwable)ex);
            throw new SocialException("Unable to delete flag from UGC");
        }
    }

    @HasPermission(action="ugc.unflag", type=SocialPermission.class)
    private boolean realUnflag(@ProtectedResource Flag flagToDelete, T ugcToUpdate) throws SocialException, MongoDataException {
        ugcToUpdate.getFlags().remove(flagToDelete);
        this.pipeline.processUgc(ugcToUpdate);
        this.ugcRepository.save(ugcToUpdate);
        this.reactor.notify((Object)UGCEvent.UNFLAG.getName(), Event.wrap((Object)new SocialEvent(ugcToUpdate, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.UNFLAG)));
        return true;
    }

    @HasPermission(action="ugc.moderate", type=SocialPermission.class)
    public SocialUgc moderate(@ProtectedResource String ugcId, ModerationStatus moderationStatus, String userId, String contextId) throws SocialException {
        try {
            SocialUgc ugc = (SocialUgc)this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                throw new IllegalUgcException("Given UGC does not exist for current user's context");
            }
            if (ugc.getModerationStatus() != ModerationStatus.TRASH) {
                ugc.setModerationStatus(moderationStatus);
            }
            this.pipeline.processUgc((UGC)ugc);
            this.ugcRepository.save((Object)ugc);
            this.reactor.notify((Object)UGCEvent.MODERATE.getName(), Event.wrap((Object)new SocialEvent((UGC)ugc, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.UNFLAG)));
            return ugc;
        }
        catch (MongoDataException ex) {
            this.log.debug("Unable to change ugc moderation status", (Throwable)ex);
            throw new UGCException("Unable to change ugc moderation status", (Throwable)ex);
        }
    }

    public Iterable<T> findByModerationStatus(ModerationStatus status, String thread, String contextId, int start, int limit, List sort) throws UGCException {
        try {
            return this.ugcRepository.findByModerationStatus(status, thread, contextId, start, limit, sort);
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to find by Moderation Status.", (Throwable)ex);
            throw new UGCException("Unable to find by status", (Throwable)ex);
        }
    }

    public long countByModerationStatus(ModerationStatus status, String thread, String contextId) throws UGCException {
        try {
            return this.ugcRepository.countFindByModerationStatus(status, thread, contextId);
        }
        catch (MongoDataException e) {
            this.log.error("Unable to count comments by Moderation Status", (Throwable)e);
            throw new UGCException("Unable to count comments by there status", (Throwable)e);
        }
    }

    public Iterable<T> findAllFlaggedUgs(String context, int start, int pageSize, List sortOrder) {
        return this.ugcRepository.findAllFlagged(context, start, pageSize, sortOrder);
    }

    public long countAllFlaggedUgs(String context, int start, int pageSize, List sortOrder) {
        return this.ugcRepository.countAllFlagged(context, start, pageSize, sortOrder);
    }

    public Map<? extends String, Object> approveComment(UGC ugc, Profile profile) throws ProfileException, SocialException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (ugc instanceof SocialUgc) {
            SocialUgc socialUgc = (SocialUgc)ugc;
            if (socialUgc.getModerationStatus() == ModerationStatus.APPROVED) {
                map.put("alreadyApprove", true);
                map.put("approver", (Boolean)this.profileService.getProfile(ugc.getLastModifiedBy(), new String[0]));
            } else {
                String moderationName;
                List roles = SocialSecurityUtils.getSocialRoles((Profile)profile);
                if (roles.contains(moderationName = (String)this.tenantConfigurationService.getProperty(ugc.getContextId(), "moderateByMailRole"))) {
                    if (socialUgc.getModerationStatus() != ModerationStatus.TRASH) {
                        socialUgc.setModerationStatus(ModerationStatus.APPROVED);
                    }
                    HashMap<String, Profile> processParams = new HashMap<String, Profile>();
                    processParams.put("modifierProfile", profile);
                    this.pipeline.processUgc((UGC)socialUgc, processParams);
                    try {
                        this.ugcRepository.save((Object)socialUgc);
                        this.reactor.notify((Object)UGCEvent.MODERATE.getName(), Event.wrap((Object)new SocialEvent((UGC)socialUgc, profile.getId().toString(), UGCEvent.UNFLAG)));
                    }
                    catch (MongoDataException e) {
                        throw new SocialException("Unable to update UGC");
                    }
                }
                map.put("alreadyApprove", false);
            }
        }
        return map;
    }

    protected void voteUp(T ugc, String userId) {
        this.unvoteDown(ugc, userId);
        ugc.getVotesUp().add(userId);
    }

    private void voteDown(T ugc, String userId) {
        this.unvoteUp(ugc, userId);
        ugc.getVotesDown().add(userId);
    }

    protected void unvoteDown(SocialUgc ugc, String userId) {
        ugc.getVotesDown().remove(userId);
    }

    private void unvoteUp(T ugc, String userId) {
        ugc.getVotesUp().remove(userId);
    }

    private void neutral(T ugc, String userId) {
        ugc.getVotesDown().remove(userId);
        ugc.getVotesUp().remove(userId);
    }

    public void setUgcRepository(UGCRepository<T> ugcRepository) {
        this.ugcRepository = ugcRepository;
    }

    public void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }

    public void setUgcPipeline(UgcPipeline ugcPipeline) {
        this.pipeline = ugcPipeline;
    }

    public void setTenantConfigurationServiceImpl(TenantConfigurationService tenantConfigurationService) {
        this.tenantConfigurationService = tenantConfigurationService;
    }

    public void setProfileServiceRestClient(ProfileService profileService) {
        this.profileService = profileService;
    }
}

