/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.system;

import com.google.common.cache.Cache;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailService {
    private Cache<String, Object> emailConfigCache;
    private ContextPreferencesService contextPreferences;

    public void sendEmail(Profile toSend, StringWriter writer, String subject, String contextId) throws SocialException {
        Map emailSettings = this.getEmailSettings(contextId);
        JavaMailSender sender = this.getSender(contextId);
        MimeMessage message = sender.createMimeMessage();
        String realSubject = subject;
        if (StringUtils.isBlank((CharSequence)realSubject)) {
            realSubject = this.generateSubjectString(emailSettings.get("subject").toString());
        }
        try {
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setTo(toSend.getEmail());
            helper.setReplyTo(emailSettings.get("replyTo").toString());
            helper.setFrom(emailSettings.get("from").toString());
            helper.setSubject(realSubject);
            helper.setPriority(NumberUtils.toInt((String)emailSettings.get("priority").toString(), (int)4));
            helper.setText(writer.toString(), true);
            message.setHeader("Message-ID", String.format("[%s]-%s-%s-%s", RandomStringUtils.randomAlphanumeric((int)5), contextId, realSubject, toSend.getId()));
            sender.send(message);
        }
        catch (MessagingException e) {
            throw new SocialException("Unable to send Email to " + toSend.getEmail(), (Throwable)e);
        }
    }

    private String generateSubjectString(String message) {
        return message;
    }

    public void updateContextEmailCache(String contextId) throws SocialException {
        String preferenceCacheKey = contextId + "-preferences";
        String javaMailCacheKey = contextId + "-javaMail";
        this.emailConfigCache.invalidate((Object)preferenceCacheKey);
        this.emailConfigCache.invalidate((Object)javaMailCacheKey);
        this.getEmailSettings(contextId);
        this.getSender(contextId);
    }

    protected Map<String, Object> getEmailSettings(String contextId) throws SocialException {
        String cacheKey = contextId + "-preferences";
        Map config = (Map)this.emailConfigCache.getIfPresent((Object)cacheKey);
        if (config != null) {
            return config;
        }
        Map toReturn = this.contextPreferences.findEmailPreference(contextId);
        this.emailConfigCache.put((Object)cacheKey, (Object)toReturn);
        return toReturn;
    }

    public JavaMailSender getSender(String contextId) throws SocialException {
        String cacheKey = contextId + "-javaMail";
        JavaMailSender config = (JavaMailSender)this.emailConfigCache.getIfPresent((Object)cacheKey);
        if (config != null) {
            return config;
        }
        return this.loadConfig(contextId + "-javaMail", this.getEmailSettings(contextId));
    }

    private JavaMailSender loadConfig(String cacheKey, Map<String, Object> emailPreferences) throws SocialException {
        if (emailPreferences != null) {
            JavaMailSenderImpl toReturn = new JavaMailSenderImpl();
            toReturn.setDefaultEncoding(emailPreferences.get("encoding").toString());
            toReturn.setHost(emailPreferences.get("host").toString());
            toReturn.setPort(NumberUtils.toInt((String)emailPreferences.get("port").toString(), (int)25));
            Properties javaMailProps = new Properties();
            if (Boolean.parseBoolean(emailPreferences.get("auth").toString())) {
                toReturn.setUsername(emailPreferences.get("username").toString());
                toReturn.setPassword(emailPreferences.get("password").toString());
                javaMailProps.put("mail.smtp.auth", "true");
            }
            if (Boolean.parseBoolean(emailPreferences.get("tls").toString())) {
                javaMailProps.put("mail.smtp.starttls.enable", "true");
            }
            toReturn.setJavaMailProperties(javaMailProps);
            this.emailConfigCache.put((Object)cacheKey, (Object)toReturn);
            return toReturn;
        }
        throw new SocialException("Email is not configured for context " + cacheKey);
    }

    public void setEmailConfigCache(Cache<String, Object> emailConfigCache) {
        this.emailConfigCache = emailConfigCache;
    }

    public void setContextPreferences(ContextPreferencesService contextPreferences) {
        this.contextPreferences = contextPreferences;
    }
}

