/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.system.impl;

import com.google.common.cache.Cache;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.ContextPreferencesRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.TenantConfigurationService;

public class ContextPreferencesServiceImpl
implements ContextPreferencesService {
    private ContextPreferencesRepository contextPreferencesRepository;
    private String invalidKeys;
    private TenantConfigurationService tenantConfigurationService;
    private Cache<String, Object> emailConfigCache;

    public Map findEmailPreference(String contextId) throws SocialException {
        return this.contextPreferencesRepository.getEmailPreference(contextId);
    }

    public String getNotificationEmailTemplate(String contextId, String notificationType) throws SocialException {
        return this.contextPreferencesRepository.findNotificationTemplate(contextId, notificationType);
    }

    public Map<String, Object> getContextPreferences(String contextId) {
        return this.contextPreferencesRepository.getContextPreferences(contextId);
    }

    public boolean saveContextPreference(String contextId, Map<String, Object> preferences) {
        HashMap<CallSite, Object> cleanPref = new HashMap<CallSite, Object>();
        for (String key : preferences.keySet()) {
            if (this.invalidKeys.contains(key)) continue;
            cleanPref.put((CallSite)((Object)("preferences." + key)), preferences.get(key));
        }
        boolean result = this.contextPreferencesRepository.setContextPreferences(cleanPref, contextId);
        if (result) {
            this.tenantConfigurationService.reloadTenant(contextId);
        }
        return result;
    }

    public boolean deleteContextPreference(String context, List<String> preferences) {
        boolean result = this.contextPreferencesRepository.deleteContextPreferences(context, preferences);
        if (result) {
            this.tenantConfigurationService.reloadTenant(context);
        }
        return result;
    }

    @HasPermission(type=SocialPermission.class, action="system.notification.changeTemplate")
    public boolean saveEmailTemplate(String context, String type, String template) throws SocialException {
        return this.contextPreferencesRepository.saveEmailTemplate(context, type, template);
    }

    @HasPermission(type=SocialPermission.class, action="system.notification.changeTemplate")
    public String getEmailTemplate(String context, String emailTemplateType) throws SocialException {
        return this.getNotificationEmailTemplate(context, emailTemplateType.toLowerCase());
    }

    public void setContextPreferencesRepository(ContextPreferencesRepository contextPreferencesRepository) {
        this.contextPreferencesRepository = contextPreferencesRepository;
    }

    public void setInvalidKeys(String invalidKeys) {
        this.invalidKeys = invalidKeys;
    }

    public Map<String, Object> saveEmailConfig(String contextId, Map<String, Object> newConfiguration) throws SocialException {
        Map result = this.contextPreferencesRepository.saveEmailConfig(contextId, newConfiguration);
        this.invalidatedEmailSettings(contextId);
        return result;
    }

    public Map<String, Object> getAllPreferences(String context) {
        return this.contextPreferencesRepository.getContextAllPreferences(context);
    }

    public void saveAllContextPreferences(String contextId, Map<String, Object> newPreferences) throws SocialException {
        this.contextPreferencesRepository.saveAllContextPreferences(contextId, newPreferences);
    }

    private void invalidatedEmailSettings(String contextId) {
        String preferenceCacheKey = contextId + "-preferences";
        String javaMailCacheKey = contextId + "-javaMail";
        this.emailConfigCache.invalidate((Object)preferenceCacheKey);
        this.emailConfigCache.invalidate((Object)javaMailCacheKey);
    }

    public void setTenantConfigurationServiceImpl(TenantConfigurationService tenantConfigurationService) {
        this.tenantConfigurationService = tenantConfigurationService;
    }

    public void setEmailConfigCache(Cache<String, Object> emailConfigCache) {
        this.emailConfigCache = emailConfigCache;
    }
}

