/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.system.impl;

import java.util.ArrayList;
import java.util.List;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.social.domain.social.system.SocialSecurityAction;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.security.PermissionRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.services.system.SecurityActionsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityActionsServiceImpl
implements SecurityActionsService {
    private Logger log = LoggerFactory.getLogger(SecurityActionsServiceImpl.class);
    private PermissionRepository permissionRepository;

    @HasPermission(type=SocialPermission.class, action="system.securityActions.read")
    public Iterable<SocialSecurityAction> get(String context) {
        this.log.debug("Finding all SecurityActions for {}", (Object)context);
        try {
            return this.permissionRepository.findActions(context);
        }
        catch (MongoDataException e) {
            this.log.error("Unable to find all Security actions for given context", (Throwable)e);
            return new ArrayList<SocialSecurityAction>();
        }
    }

    @HasPermission(type=SocialPermission.class, action="system.securityActions.update")
    public SocialSecurityAction update(String context, String actionName, List<String> roles) throws SocialException {
        this.log.debug("Updating Roles for {} of context {} to {}", new Object[]{actionName, context, roles});
        try {
            if (actionName.toLowerCase().startsWith("system.")) {
                throw new IllegalArgumentException("System Actions can't be changed");
            }
            return this.permissionRepository.updateSecurityAction(context, actionName, roles);
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to Update Security Action", (Throwable)ex);
            throw new SocialException("Unable to removeWatcher Security Action", (Throwable)ex);
        }
    }

    public void save(SocialSecurityAction action) throws SocialException {
        this.log.debug("Creating new Action {}", (Object)action);
        try {
            this.permissionRepository.save(action);
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to save new action", (Throwable)ex);
            throw new SocialException("Unable to save new Action");
        }
    }

    public void setPermissionRepositoryImpl(PermissionRepository permissionRepository) {
        this.permissionRepository = permissionRepository;
    }
}

