/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.system.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.domain.social.system.SocialContext;
import org.craftercms.social.domain.social.system.SocialSecurityAction;
import org.craftercms.social.exceptions.ProfileConfigurationException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.SocialContextRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.SecurityActionsService;
import org.craftercms.social.services.system.SocialContextService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialContextServiceImpl
implements SocialContextService {
    public static final String FIRST_NAME_ATTRIBUTE = "firstName";
    public static final String LAST_NAME_ATTRIBUTE = "lastName";
    public static final String DISPLAY_NAME_ATTRIBUTE = "displayName";
    public static final String AVATAR_LINK_ATTRIBUTE = "avatarLink";
    private SocialContextRepository socialContextRepository;
    private ProfileService profileService;
    private SecurityActionsService securityActionsService;
    private ContextPreferencesService contextPreferencesService;
    protected EntitlementValidator entitlementValidator;
    private Logger log = LoggerFactory.getLogger(SocialContextServiceImpl.class);

    public Iterable<SocialContext> getAllContexts() throws SocialException {
        try {
            List socialContexts = IterableUtils.toList((Iterable)this.socialContextRepository.findAll());
            ArrayList<SocialContext> actualList = new ArrayList<SocialContext>();
            for (SocialContext socialContext : socialContexts) {
                if (SocialSecurityUtils.getCurrentProfile().hasRole("SOCIAL_SUPERADMIN")) {
                    actualList.add(socialContext);
                    continue;
                }
                List contextRoles = SocialSecurityUtils.getRolesForCurrentContext((String)socialContext.getId(), (Profile)SocialSecurityUtils.getCurrentProfile());
                if (!contextRoles.contains("SOCIAL_ADMIN")) continue;
                actualList.add(socialContext);
            }
            return actualList;
        }
        catch (MongoDataException e) {
            this.log.error("Unable to find all Social Context", (Throwable)e);
            throw new SocialException("Unable to find social context", (Throwable)e);
        }
    }

    @HasPermission(type=SocialPermission.class, action="system.socialctx.create")
    public SocialContext createNewContext(String contextName) throws SocialException {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.SITE, 1);
        }
        catch (Exception e) {
            throw new SocialException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Throwable)e);
        }
        SocialContext context = new SocialContext(contextName);
        try {
            this.socialContextRepository.save((Object)context);
            this.createDefaultActionsForContext(context, "TEMPLATE_CONTEXT_ACTIONS");
            this.createDefaultPreferencesForContext(context, "TEMPLATE_CONTEXT_ACTIONS");
            return context;
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to save new social Context", (Throwable)ex);
            throw new SocialException("Unable to save Social Context", (Throwable)ex);
        }
    }

    private void createDefaultPreferencesForContext(SocialContext context, String templateContextActions) throws SocialException {
        Map prefs = this.contextPreferencesService.getAllPreferences(templateContextActions);
        prefs.put("_id", context.getId());
        this.contextPreferencesService.saveAllContextPreferences(context.getId(), prefs);
    }

    @HasPermission(type=SocialPermission.class, action="system.socialctx.create")
    private void createDefaultActionsForContext(SocialContext context, String templateContextId) throws SocialException {
        Iterable actions = this.securityActionsService.get(templateContextId);
        for (SocialSecurityAction action : actions) {
            action.setId(null);
            action.setContextId(context.getId());
            this.securityActionsService.save(action);
        }
    }

    @HasPermission(type=SocialPermission.class, action="system.socialctx.addProfile")
    public Profile addProfileToContext(String profileId, String contextId, String[] roles) throws SocialException {
        try {
            Profile p = this.profileService.getProfile(profileId, new String[]{"socialContexts"});
            if (p == null) {
                throw new ProfileConfigurationException("Given profile \"" + profileId + "\" does not exist");
            }
            HashMap<String, List<Map>> attributesToUpdate = new HashMap<String, List<Map>>();
            List<Map> socialContexts = (List<Map>)p.getAttribute("socialContexts");
            SocialContext ctx = (SocialContext)this.socialContextRepository.findById(contextId);
            if (ctx == null) {
                throw new ProfileConfigurationException("Given context \"" + contextId + "\" does not exist");
            }
            if (CollectionUtils.isEmpty((Collection)socialContexts)) {
                HashMap<String, Object> socialContext = new HashMap<String, Object>();
                socialContext.put("name", ctx.getContextName());
                socialContext.put("id", ctx.getId());
                socialContext.put("roles", Arrays.asList(roles));
                socialContexts = Arrays.asList(socialContext);
            } else {
                boolean foundOne = false;
                for (Map socialContext : socialContexts) {
                    if (!socialContext.containsValue(ctx.getId())) continue;
                    socialContext.put("roles", Arrays.asList(roles));
                    foundOne = true;
                    break;
                }
                if (!foundOne) {
                    HashMap<String, Object> newCtx = new HashMap<String, Object>();
                    newCtx.put("name", ctx.getContextName());
                    newCtx.put("id", ctx.getId());
                    newCtx.put("roles", Arrays.asList(roles));
                    socialContexts.add(newCtx);
                }
            }
            attributesToUpdate.put("socialContexts", socialContexts);
            return this.profileService.updateAttributes(profileId, attributesToUpdate, new String[]{FIRST_NAME_ATTRIBUTE, LAST_NAME_ATTRIBUTE, DISPLAY_NAME_ATTRIBUTE, AVATAR_LINK_ATTRIBUTE, "socialContexts"});
        }
        catch (ProfileException e) {
            this.log.error("Unable to find profile with given id " + profileId, (Throwable)e);
            throw new SocialException("Unable to find profile ", (Throwable)e);
        }
        catch (MongoDataException e) {
            this.log.error("Unable to look for SocialContext", (Throwable)e);
            throw new SocialException("Unable to find Context by id", (Throwable)e);
        }
    }

    @HasPermission(type=SocialPermission.class, action="system.socialctx.removeProfile")
    public Profile removeProfileFromContext(String contextId, String profileId) throws SocialException {
        try {
            Profile p = this.profileService.getProfile(profileId, new String[]{"socialContexts"});
            if (p == null) {
                throw new ProfileConfigurationException("Given profile \"" + profileId + "\" does not exist");
            }
            SocialContext ctx = (SocialContext)this.socialContextRepository.findById(contextId);
            if (ctx == null) {
                throw new ProfileConfigurationException("Given context \"" + contextId + "\" does not exist");
            }
            ArrayList<Map> updatedList = new ArrayList<Map>();
            HashMap<String, ArrayList<Map>> attributesToUpdate = new HashMap<String, ArrayList<Map>>();
            List socialContexts = (List)p.getAttribute("socialContexts");
            if (socialContexts == null) {
                return p;
            }
            for (Map socialContext : socialContexts) {
                if (socialContext.containsValue(ctx.getId())) continue;
                updatedList.add(socialContext);
            }
            attributesToUpdate.put("socialContexts", updatedList);
            return this.profileService.updateAttributes(profileId, attributesToUpdate, new String[]{FIRST_NAME_ATTRIBUTE, LAST_NAME_ATTRIBUTE, DISPLAY_NAME_ATTRIBUTE, AVATAR_LINK_ATTRIBUTE, "socialContexts"});
        }
        catch (ProfileException ex) {
            this.log.error("Unable to find profile with given id " + profileId, (Throwable)ex);
            throw new SocialException("Unable to find profile ", (Throwable)ex);
        }
        catch (MongoDataException e) {
            this.log.error("Unable to look for SocialContext", (Throwable)e);
            throw new SocialException("Unable to find Context by id", (Throwable)e);
        }
    }

    public void setSocialContextRepositoryImpl(SocialContextRepository socialContextRepository) {
        this.socialContextRepository = socialContextRepository;
    }

    public void setSecurityActionsService(SecurityActionsService securityActionsService) {
        this.securityActionsService = securityActionsService;
    }

    public void setProfileServiceRestClient(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setContextPreferencesService(ContextPreferencesService contextPreferencesService) {
        this.contextPreferencesService = contextPreferencesService;
    }

    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }
}

