/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.system.impl;

import com.google.common.cache.Cache;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.social.domain.system.ContextPreferences;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.repositories.system.ContextPreferencesRepository;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.TenantConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class TenantConfigurationServiceImpl
implements TenantConfigurationService {
    private Cache<String, Map<String, Object>> tenantConfigCache;
    private Properties systemDefaults;
    private List<Resource> defaultLocations;
    private ContextPreferencesService contextPreferencesService;
    private Logger log = LoggerFactory.getLogger(TenantConfigurationServiceImpl.class);
    private ContextPreferencesRepository contextPreferencesRepository;

    public <T> T getProperty(String contextId, String propertyName) {
        Map tenantConfig = null;
        Object pValue = null;
        if (this.tenantConfigCache.asMap().containsKey(contextId)) {
            tenantConfig = (Map)this.tenantConfigCache.getIfPresent((Object)contextId);
        }
        if (tenantConfig == null) {
            this.reloadTenant(contextId);
            Map tenantCacheConfig = (Map)this.tenantConfigCache.getIfPresent((Object)contextId);
            if (tenantCacheConfig != null) {
                tenantConfig = tenantCacheConfig;
            }
        }
        if (tenantConfig != null && tenantConfig.containsKey(propertyName)) {
            pValue = tenantConfig.get(propertyName);
        } else if (this.systemDefaults.containsKey(propertyName)) {
            pValue = this.systemDefaults.get(propertyName);
        } else {
            this.log.info("The configuration key {} does not exist as a tenant property or as a system property", (Object)propertyName);
        }
        return (T)pValue;
    }

    public void reloadTenant(String contextId) {
        Map pref = this.contextPreferencesService.getContextPreferences(contextId);
        if (pref.containsKey("preferences")) {
            HashMap<String, String> prefMap = new HashMap<String, String>((HashMap)pref.get("preferences"));
            prefMap.put("contextId", contextId);
            if (pref != null) {
                this.tenantConfigCache.invalidate((Object)contextId);
                this.tenantConfigCache.put((Object)contextId, prefMap);
            } else {
                this.log.error("Unable to get preferences for context {} will not update", (Object)contextId);
            }
        } else {
            this.log.error("Context has empty  preferences {} ignoring", (Object)contextId);
        }
    }

    public void loadDefaults() throws MongoDataException, SocialException {
        this.systemDefaults = new Properties();
        for (Resource resource : this.defaultLocations) {
            if (!resource.exists() || !resource.isReadable()) continue;
            try {
                InputStream in = resource.getInputStream();
                this.systemDefaults.load(in);
                in.close();
            }
            catch (IOException ex) {
                this.log.error("Unable to read file " + resource.getFilename(), (Throwable)ex);
            }
        }
        if (this.systemDefaults.isEmpty()) {
            throw new IllegalStateException("System default properties are empty");
        }
        List toCache = this.getAllPreferences();
        for (Map contextPref : toCache) {
            this.tenantConfigCache.put((Object)((String)contextPref.get("contextId")), (Object)contextPref);
        }
    }

    protected List<Map<String, Object>> getAllPreferences() throws SocialException {
        ArrayList<Map<String, Object>> toReturn = new ArrayList<Map<String, Object>>();
        try {
            Iterable preferences = this.contextPreferencesRepository.findAll();
            if (preferences != null) {
                for (ContextPreferences pref : preferences) {
                    HashMap<String, String> toAdd = new HashMap<String, String>();
                    if (pref.getPreferences() != null) {
                        toAdd.putAll(pref.getPreferences());
                    }
                    toAdd.put("contextId", pref.getContextId());
                    toReturn.add(toAdd);
                }
            }
            return toReturn;
        }
        catch (MongoDataException e) {
            throw new SocialException("Unable to get preferences", (Throwable)e);
        }
    }

    public void setTenantConfigCache(Cache<String, Map<String, Object>> tenantConfigCache) {
        this.tenantConfigCache = tenantConfigCache;
    }

    public void setDefaultLocations(List<Resource> defaultLocations) {
        this.defaultLocations = defaultLocations;
    }

    public void setContextPreferencesServiceImpl(ContextPreferencesService contextPreferencesService) {
        this.contextPreferencesService = contextPreferencesService;
    }

    public void setContextPreferencesRepository(ContextPreferencesRepository contextPreferencesRepository) {
        this.contextPreferencesRepository = contextPreferencesRepository;
    }
}

