/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.ugc.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.collections4.keyvalue.DefaultKeyValue;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.craftercms.commons.collections.IterableUtils;
import org.craftercms.commons.entitlements.model.EntitlementType;
import org.craftercms.commons.entitlements.validator.EntitlementValidator;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.mongo.FileInfo;
import org.craftercms.commons.mongo.MongoDataException;
import org.craftercms.commons.security.permissions.annotations.HasPermission;
import org.craftercms.commons.security.permissions.annotations.ProtectedResource;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.controllers.rest.v3.comments.exceptions.UGCNotFound;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.domain.social.ModerationStatus;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.IllegalSocialQueryException;
import org.craftercms.social.exceptions.IllegalUgcException;
import org.craftercms.social.exceptions.NotificationException;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.exceptions.UGCException;
import org.craftercms.social.repositories.UgcFactory;
import org.craftercms.social.repositories.ugc.UGCRepository;
import org.craftercms.social.security.SocialPermission;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.services.system.TenantConfigurationService;
import org.craftercms.social.services.ugc.UGCService;
import org.craftercms.social.services.ugc.pipeline.UgcPipeline;
import org.craftercms.social.util.LoggerFactory;
import org.craftercms.social.util.ebus.SocialEvent;
import org.craftercms.social.util.ebus.UGCEvent;
import org.craftercms.virusscanner.api.VirusScanner;
import org.craftercms.virusscanner.impl.VirusScannerException;
import reactor.core.Reactor;
import reactor.event.Event;

public class UGCServiceImpl<T extends UGC>
implements UGCService {
    private I10nLogger log = LoggerFactory.getLogger(UGCServiceImpl.class);
    private UGCRepository ugcRepository;
    private UgcPipeline pipeline;
    private Pattern invalidQueryKeys;
    private UgcFactory ugcFactory;
    private VirusScanner virusScanner;
    private Reactor reactor;
    private NotificationService notificationService;
    private List<String> arraySortFields;
    private TenantConfigurationService tenantConfigurationService;
    private ProfileService profileService;
    protected EntitlementValidator entitlementValidator;

    @HasPermission(action="ugc.create", type=SocialPermission.class)
    public UGC create(String contextId, String ugcParentId, String targetId, String textContent, String subject, Map attrs, boolean isAnonymous) throws SocialException {
        try {
            this.entitlementValidator.validateEntitlement(EntitlementType.ITEM, 1);
        }
        catch (Exception e) {
            throw new SocialException("Unable to complete request due to entitlement limits. Please contact your system administrator.", (Throwable)e);
        }
        this.log.debug("logging.ugc.creatingUgc", new Object[]{contextId, targetId, ugcParentId, subject, attrs});
        UGC template = new UGC(subject, textContent, targetId);
        template.setAnonymousFlag(isAnonymous);
        UGC newUgc = this.ugcFactory.newInstance(template);
        newUgc.setAttributes(attrs);
        try {
            if (ObjectId.isValid((String)ugcParentId)) {
                this.setupAncestors(newUgc, ugcParentId, contextId);
            } else {
                this.log.debug("logging.ugc.invalidParentId", new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)contextId)) {
                throw new IllegalArgumentException("context cannot be null");
            }
            this.pipeline.processUgc(newUgc);
            this.ugcRepository.save((Object)newUgc);
            SocialEvent event = new SocialEvent(newUgc, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.CREATE);
            event.setAttribute("baseUrl", (Object)this.calculateBaseUrl());
            this.reactor.notify((Object)UGCEvent.CREATE.getName(), Event.wrap((Object)event));
            this.setupAutoWatch(targetId, SocialSecurityUtils.getCurrentProfile(), contextId);
            this.log.info("logging.ugc.created", new Object[]{newUgc});
            return newUgc;
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.errorSaving", (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to Save UGC");
        }
    }

    private String calculateBaseUrl() {
        HttpServletRequest request = RequestContext.getCurrent().getRequest();
        return request.getScheme() + "://" + request.getServerName() + (String)("http".equals(request.getScheme()) && request.getServerPort() == 80 || "https".equals(request.getScheme()) && request.getServerPort() == 443 ? "" : ":" + request.getServerPort()) + request.getContextPath();
    }

    public void setNotificationServiceImpl(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    private void setupAutoWatch(String targetId, Profile currentProfile, String context) throws NotificationException {
        Map profileMap = currentProfile.getAttributes();
        if (profileMap.containsKey("defaultFrequency") && profileMap.containsKey("autoWatch")) {
            boolean autoWatch = (Boolean)currentProfile.getAttribute("autoWatch");
            if (autoWatch) {
                this.notificationService.subscribeUser(currentProfile, context + "/" + targetId, (String)currentProfile.getAttribute("defaultFrequency"));
            }
        } else if (Boolean.valueOf(this.tenantConfigurationService.getProperty(context, "setupAutoWatch").toString()).booleanValue()) {
            try {
                currentProfile.setAttribute("autoWatch", (Object)true);
                currentProfile.setAttribute("defaultFrequency", this.tenantConfigurationService.getProperty(context, "defaultFrequency"));
                HashMap<String, Object> updatedMap = new HashMap<String, Object>();
                updatedMap.put("autoWatch", true);
                updatedMap.put("defaultFrequency", this.tenantConfigurationService.getProperty(context, "defaultFrequency"));
                Profile updatedProfile = this.profileService.updateAttributes(currentProfile.getId().toString(), updatedMap, new String[0]);
                this.setupAutoWatch(targetId, updatedProfile, context);
            }
            catch (ProfileException ex) {
                this.log.error("logging.ugc.autowatch", new Object[]{currentProfile.getId().toString(), ex});
            }
        } else {
            this.log.debug("Profile doesn't have either defaultFrequency or autoWatch attributes set", new Object[0]);
        }
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public void setAttributes(@ProtectedResource String ugcId, String contextId, Map attributes) throws SocialException, UGCNotFound {
        this.log.debug("logging.ugc.addingAttributes", new Object[]{attributes, ugcId, contextId});
        try {
            UGC toUpdate = this.ugcRepository.findUGC(contextId, ugcId);
            if (toUpdate == null) {
                throw new UGCNotFound("Unable to find ugc with id " + ugcId);
            }
            Map attrs = toUpdate.getAttributes();
            attrs.putAll(attributes);
            this.ugcRepository.setAttributes(ugcId, contextId, attrs);
            SocialEvent event = new SocialEvent(ugcId, attributes, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.UPDATE_ATTRIBUTES);
            event.setAttribute("baseUrl", (Object)this.calculateBaseUrl());
            this.reactor.notify((Object)UGCEvent.UPDATE_ATTRIBUTES.getName(), Event.wrap((Object)event));
        }
        catch (MongoDataException ex) {
            this.log.debug("logging.ugc.unableToAddAttrs", (Throwable)ex, new Object[]{attributes, ugcId, contextId});
            throw new UGCException("Unable to add Attributes to UGC", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public void deleteAttribute(@ProtectedResource String ugcId, String[] attributesName, String contextId) throws SocialException {
        this.log.debug("logging.ugc.deleteAttributes", new Object[]{attributesName, ugcId});
        try {
            this.ugcRepository.deleteAttribute(ugcId, contextId, attributesName);
            SocialEvent event = new SocialEvent(ugcId, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.DELETE_ATTRIBUTES);
            event.setAttribute("baseUrl", (Object)this.calculateBaseUrl());
            this.reactor.notify((Object)UGCEvent.DELETE_ATTRIBUTES.getName(), Event.wrap((Object)event));
        }
        catch (MongoDataException ex) {
            this.log.debug("logging.ugc.unableToDelAttrs", (Throwable)ex, new Object[]{attributesName, ugcId});
            throw new UGCException("Unable to delete attribute for ugc", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.delete", type=SocialPermission.class)
    public boolean deleteUgc(String ugcId, String contextId) throws SocialException {
        this.log.debug("logging.ugc.deleteUgc", new Object[]{ugcId});
        try {
            this.ugcRepository.deleteUgc(ugcId, contextId);
            SocialEvent event = new SocialEvent(ugcId, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.DELETE);
            event.setAttribute("baseUrl", (Object)this.calculateBaseUrl());
            this.reactor.notify((Object)UGCEvent.DELETE.getName(), Event.wrap((Object)event));
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.deleteUgcError", (Throwable)ex, new Object[]{ugcId, contextId});
            throw new UGCException("Unable to delete UGC", (Throwable)ex);
        }
        return false;
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public UGC update(@ProtectedResource String ugcId, String body, String subject, String contextId, Map attributes) throws SocialException, UGCNotFound {
        this.log.debug("logging.ugc.updateUgc", new Object[]{ugcId});
        try {
            Profile currentProfile = SocialSecurityUtils.getCurrentProfile();
            boolean moderateByMail = Boolean.parseBoolean(this.tenantConfigurationService.getProperty(contextId, "moderateByMailEnable").toString());
            if (!ObjectId.isValid((String)ugcId)) {
                throw new IllegalArgumentException("Given UGC Id is not valid");
            }
            UGC toUpdate = this.ugcRepository.findUGC(contextId, ugcId);
            if (toUpdate == null) {
                throw new IllegalArgumentException("UGC with Id " + ugcId + " does not exist");
            }
            if (StringUtils.isNotBlank((CharSequence)body)) {
                toUpdate.setBody(body);
            }
            if (StringUtils.isNotBlank((CharSequence)subject)) {
                toUpdate.setBody(subject);
            }
            this.pipeline.processUgc(toUpdate);
            if (moderateByMail && !SocialSecurityUtils.isProfileModeratorOrAdmin((Profile)currentProfile, (String)contextId) && toUpdate instanceof SocialUgc) {
                ((SocialUgc)toUpdate).setModerationStatus(ModerationStatus.UNMODERATED);
            }
            this.ugcRepository.update(ugcId, (Object)toUpdate, false, false);
            SocialEvent event = new SocialEvent(toUpdate, SocialSecurityUtils.getCurrentProfile().getId().toString(), UGCEvent.UPDATE);
            event.setAttribute("baseUrl", (Object)this.calculateBaseUrl());
            this.reactor.notify((Object)UGCEvent.UPDATE.getName(), Event.wrap((Object)event));
            if (attributes != null && !attributes.isEmpty()) {
                toUpdate.getAttributes().putAll(attributes);
                this.setAttributes(toUpdate.getId().toString(), contextId, toUpdate.getAttributes());
                this.reactor.notify((Object)UGCEvent.UPDATE_ATTRIBUTES, Event.wrap((Object)attributes));
            }
            this.log.info("logging.ugc.updatedUgc", new Object[]{ugcId});
            return toUpdate;
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.unableToUpdateUgc", (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to removeWatcher UGC", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public T read(String ugcId, boolean includeChildren, int childCount, String contextId) throws UGCException {
        try {
            if (includeChildren) {
                return (T)this.getUgcTree(ugcId, childCount, contextId);
            }
            return (T)this.ugcRepository.findUGC(contextId, ugcId);
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.unableToRead", new Object[0]);
            throw new UGCException("Unable to find ugc by name");
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public Iterable<T> readByTargetId(String targetId, String contextId) throws UGCException {
        this.log.debug("logging.ugc.findingByTarget", new Object[]{targetId, contextId});
        try {
            return this.buildUgcTreeList(IterableUtils.toList((Iterable)this.ugcRepository.findByTargetId(targetId, contextId)), Integer.MAX_VALUE);
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.unableRead", (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to ", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public Iterable<T> search(String contextId, String query, String sort, int start, int limit) throws UGCException {
        this.log.debug("Finding all ugc of context {} with user query {} sorted by {} skipping {} and with a limit of {}", new Object[]{contextId, query, sort, start, limit});
        this.isQueryValid(query);
        try {
            return this.ugcRepository.findByUserQuery(contextId, query, sort, start, limit);
        }
        catch (MongoDataException ex) {
            this.log.error("Unable to find User with given query" + query + " sorted by " + sort, (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to find Ugc with user query ", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public FileInfo addAttachment(@ProtectedResource String ugcId, String contextId, InputStream attachment, String fileName, String contentType) throws FileExistsException, UGCException {
        String internalFileName = File.separator + contextId + File.separator + ugcId + File.separator + fileName;
        try {
            this.checkForVirus(attachment);
        }
        catch (IOException | VirusScannerException ex) {
            this.log.error("logging.ugc.errorScanVirus", ex, new Object[0]);
            return null;
        }
        try {
            UGC ugc = this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                throw new IllegalUgcException("UGC with given Id does not exist");
            }
            FileInfo info = this.ugcRepository.saveFile(attachment, internalFileName, contentType);
            try {
                info.setFileName(new URLCodec().decode(fileName));
            }
            catch (DecoderException e) {
                info.setFileName(fileName);
            }
            info.setAttribute("owner", (Object)ugcId);
            ugc.getAttachments().add(info);
            this.ugcRepository.update(ugcId, (Object)ugc);
            this.reactor.notify((Object)UGCEvent.ADD_ATTACHMENT.getName(), Event.wrap((Object)new SocialEvent(ugcId, new InputStream[]{new CloseShieldInputStream(attachment)})));
            return info;
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.unableToSaveAttachment", (Throwable)e, new Object[]{internalFileName});
            throw new UGCException("Unable to save File to UGC");
        }
    }

    private void checkForVirus(InputStream attachment) throws IOException {
        this.virusScanner.scan((InputStream)new CloseShieldInputStream(attachment));
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public void removeAttachment(@ProtectedResource String ugcId, String contextId, String attachmentId) throws UGCException, FileNotFoundException {
        try {
            UGC ugc = this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                throw new IllegalUgcException("UGC with given Id does not exist");
            }
            if (!ObjectId.isValid((String)attachmentId)) {
                throw new IllegalArgumentException("Given Attachment id is not valid");
            }
            ObjectId attachmentOid = new ObjectId(attachmentId);
            FileInfo info = this.ugcRepository.getFileInfo(attachmentOid);
            if (!info.getStoreName().startsWith(File.separator + contextId)) {
                throw new IllegalSocialQueryException("Given Attachment does not belong to the given context");
            }
            ugc.getAttachments().remove(info);
            this.ugcRepository.deleteFile(attachmentOid);
            this.ugcRepository.update(ugcId, (Object)ugc);
            this.reactor.notify((Object)UGCEvent.DELETE_ATTACHMENT.getName(), Event.wrap((Object)new SocialEvent(ugcId, attachmentId, UGCEvent.DELETE_ATTACHMENT)));
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.attachmentToRemove", (Throwable)e, new Object[]{attachmentId});
            throw new UGCException("Unable to save File to UGC");
        }
    }

    @HasPermission(action="ugc.update", type=SocialPermission.class)
    public FileInfo updateAttachment(@ProtectedResource String ugcId, String contextId, String attachmentId, InputStream newAttachment) throws UGCException, FileNotFoundException {
        if (!ObjectId.isValid((String)ugcId)) {
            throw new IllegalArgumentException("Given Ugc Id is not valid");
        }
        if (!ObjectId.isValid((String)attachmentId)) {
            throw new IllegalArgumentException("Given UGC Id is not valid");
        }
        try {
            UGC ugc = this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                throw new IllegalUgcException("Given UGC Id does not exist");
            }
            FileInfo oldInfo = this.ugcRepository.getFileInfo(new ObjectId(attachmentId));
            FileInfo newInfo = this.ugcRepository.updateFile(new ObjectId(attachmentId), newAttachment, oldInfo.getStoreName(), oldInfo.getContentType(), true);
            ugc.getAttachments().add(newInfo);
            ugc.getAttachments().remove(oldInfo);
            this.ugcRepository.update(ugcId, (Object)ugc);
            this.reactor.notify((Object)UGCEvent.DELETE_ATTACHMENT.getName(), Event.wrap((Object)new SocialEvent(ugcId, attachmentId, UGCEvent.DELETE_ATTACHMENT)));
            this.reactor.notify((Object)UGCEvent.ADD_ATTACHMENT.getName(), Event.wrap((Object)new SocialEvent(ugcId, new InputStream[]{new CloseShieldInputStream(newAttachment)}), (Object)UGCEvent.ADD_ATTACHMENT));
            return newInfo;
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.attachmentError", new Object[0]);
            throw new UGCException("Unable to removeWatcher Attachment");
        }
        catch (FileExistsException e) {
            this.log.error("logging.ugc.attachmentNotFound", new Object[]{attachmentId});
            throw new UGCException("Unable to find attachment with given id", (Throwable)e);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public FileInfo readAttachment(String ugcId, String contextId, String attachmentId) throws FileNotFoundException, UGCException {
        if (!ObjectId.isValid((String)ugcId)) {
            throw new IllegalArgumentException("Given Ugc Id is not valid");
        }
        if (!ObjectId.isValid((String)attachmentId)) {
            throw new IllegalArgumentException("Given attachment Id is not valid");
        }
        try {
            UGC ugc = this.ugcRepository.findUGC(contextId, ugcId);
            if (ugc == null) {
                throw new IllegalUgcException("UGC with given Id does not exist");
            }
            ObjectId attachmentOid = new ObjectId(attachmentId);
            FileInfo info = this.ugcRepository.readFile(attachmentOid);
            if (!info.getStoreName().startsWith(File.separator + contextId)) {
                throw new IllegalSocialQueryException("Given Attachment does not belong to the given context");
            }
            return info;
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.attachmentNotFound", (Throwable)ex, new Object[]{attachmentId});
            throw new UGCException("Unable to read file", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public List<T> read(String targetId, String contextId, int start, int limit, List sortOrder, int upToLevel, int childrenPerLevel) throws UGCException {
        try {
            List list = IterableUtils.toList((Iterable)this.ugcRepository.findByTargetId(targetId, contextId, start, limit, sortOrder, upToLevel));
            list = this.sortByArrays(list, sortOrder);
            return this.buildUgcTreeList(list, childrenPerLevel);
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.unableToRead", new Object[0]);
            throw new UGCException("Unable to find ugc by target");
        }
    }

    private List<T> sortByArrays(List<T> list, List<DefaultKeyValue<String, Boolean>> sortOrder) {
        if (sortOrder == null || list == null) {
            return list;
        }
        for (DefaultKeyValue<String, Boolean> sort : sortOrder) {
            if (!this.arraySortFields.contains(sort.getKey())) continue;
            Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return list;
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public List<T> readChildren(String ugcId, String targetId, String contextId, int start, int limit, List sortOrder, int upToLevel, int childrenPerLevel) throws UGCException, UGCNotFound {
        this.log.debug("logging.ugc.readChildren", new Object[]{ugcId, contextId, limit, start});
        try {
            return this.buildUgcTreeList(IterableUtils.toList((Iterable)this.ugcRepository.findChildren(ugcId, targetId, contextId, start, limit, sortOrder, upToLevel)), childrenPerLevel);
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.unableToRead", (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to ", (Throwable)ex);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public UGC read(String ugcId, String contextId) throws UGCException {
        try {
            return this.ugcRepository.findUGC(contextId, ugcId);
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.unableToReadP", (Throwable)e, new Object[]{ugcId, contextId});
            throw new UGCException("Unable to find UGC with given ID and context");
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public long count(String threadId, String contextId) throws UGCException {
        try {
            return this.ugcRepository.countByTargetId(contextId, threadId, 0);
        }
        catch (MongoDataException e) {
            this.log.error("logging.ugc.unableToCount", new Object[0]);
            throw new UGCException("Unable to count UGC by target and context", (Throwable)e);
        }
    }

    @HasPermission(action="ugc.read", type=SocialPermission.class)
    public long countChildren(String ugcId, String contextId) throws UGCException {
        try {
            return this.ugcRepository.countChildrenOf(contextId, ugcId);
        }
        catch (MongoDataException ex) {
            this.log.error("logging.ugc.unableToCount", (Throwable)ex, new Object[0]);
            throw new UGCException("Unable to count children of Ugc");
        }
    }

    private void isQueryValid(String query) {
        if (this.invalidQueryKeys.matcher(query).find()) {
            throw new IllegalSocialQueryException("Given Query '" + query + "' contains invalid selectors");
        }
    }

    protected List<T> buildUgcTreeList(List<T> ugs, int childrenPerLevel) {
        if (ugs.isEmpty()) {
            return null;
        }
        ArrayList<UGC> toReturn = new ArrayList<UGC>();
        LinkedList<T> stack = new LinkedList<T>();
        stack.addAll(ugs);
        while (!stack.isEmpty()) {
            UGC tmp = (UGC)stack.pop();
            if (this.findRelatives(ugs, tmp, childrenPerLevel)) continue;
            toReturn.add(tmp);
        }
        return toReturn;
    }

    protected boolean findRelatives(List<T> ugs, T ugcToTest, int childrenPerLevel) {
        for (UGC ug : ugs) {
            if (ugcToTest.isMyParent(ug) && ug.getChildren().size() < childrenPerLevel) {
                ug.getChildren().add(ugcToTest);
                return true;
            }
            if (!ug.isMyChild(ugcToTest) || ugcToTest.getChildren().size() >= childrenPerLevel) continue;
            ugcToTest.getChildren().add(ug);
            return true;
        }
        return false;
    }

    private void setupAncestors(UGC newUgc, String ugcParentId, String contextId) throws MongoDataException, UGCException {
        UGC parent = this.ugcRepository.findUGC(contextId, ugcParentId);
        if (parent == null) {
            throw new UGCException("Parent UGC does not exist");
        }
        ObjectId parentId = new ObjectId(ugcParentId);
        Object ancestors = parent.getAncestors().clone();
        if (((ArrayDeque)ancestors).isEmpty() || !((ObjectId)((ArrayDeque)ancestors).getLast()).equals((Object)parentId)) {
            ((ArrayDeque)ancestors).addLast(parentId);
            newUgc.setAncestors((ArrayDeque)ancestors);
        }
    }

    public void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }

    public void setUGCRepositoryImpl(UGCRepository UGCRepositoryImpl2) {
        this.ugcRepository = UGCRepositoryImpl2;
    }

    public void setPipeline(UgcPipeline pipeline) {
        this.pipeline = pipeline;
    }

    public void setInvalidQueryKeys(String invalidQueryKeysPattern) {
        this.invalidQueryKeys = Pattern.compile(invalidQueryKeysPattern, 34);
    }

    public void setArraySortFields(String arraySortFields) {
        this.arraySortFields = Arrays.asList(arraySortFields.split(","));
    }

    public void setSocialUgcFactory(UgcFactory ugcFactory) {
        this.ugcFactory = ugcFactory;
    }

    public void setVirusScanner(VirusScanner virusScanner) {
        this.virusScanner = virusScanner;
    }

    protected T buildUgcTree(List<T> ugs) {
        if (ugs.isEmpty()) {
            return null;
        }
        LinkedList<T> stack = new LinkedList<T>();
        stack.addAll(ugs);
        UGC root = (UGC)stack.pop();
        root.setChildren(new ArrayDeque());
        while (!stack.isEmpty()) {
            UGC tmp = (UGC)stack.pop();
            if (tmp.isMyParent(root)) {
                root.getChildren().add(tmp);
                continue;
            }
            this.findMyParent((Collection)root.getChildren(), tmp);
        }
        return (T)root;
    }

    protected void findMyParent(Collection<T> possibleParents, UGC orphanChild) {
        for (UGC child : possibleParents) {
            if (!orphanChild.isMyParent(child)) continue;
            child.getChildren().add(orphanChild);
            return;
        }
        for (UGC child : possibleParents) {
            this.findMyParent((Collection)child.getChildren(), orphanChild);
        }
    }

    private T getUgcTree(String ugcId, int childCount, String contextId) throws MongoDataException {
        List list = this.ugcRepository.findChildrenOf(ugcId, childCount, contextId);
        return (T)this.buildUgcTree(list);
    }

    public void setTenantConfigurationService(TenantConfigurationService tenantConfigurationService) {
        this.tenantConfigurationService = tenantConfigurationService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setEntitlementValidator(EntitlementValidator entitlementValidator) {
        this.entitlementValidator = entitlementValidator;
    }
}

