/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.services.ugc.pipeline;

import java.util.Map;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.domain.social.Flag;
import org.craftercms.social.domain.social.SocialUgc;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.ugc.UgcPipe;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;

public class HtmlCleanupPipe
implements UgcPipe {
    private final Whitelist whitelist = Whitelist.relaxed().addTags(new String[]{"div", "em"});

    public <T extends UGC> void process(T ugc, Map<String, Object> params) throws SocialException {
        ugc.setBody(this.cleanup(ugc.getBody()));
        if (ugc instanceof SocialUgc) {
            for (Flag flag : ((SocialUgc)ugc).getFlags()) {
                flag.setReason(this.cleanup(flag.getReason()));
            }
        }
    }

    private String cleanup(String toCleanup) {
        return Jsoup.clean((String)toCleanup, (Whitelist)this.whitelist);
    }
}

