/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util;

import java.util.HashMap;
import java.util.List;
import org.bson.types.ObjectId;
import org.craftercms.social.util.Hierarchical;
import org.craftercms.social.util.HierarchyList;

public class HierarchyGenerator {
    private HierarchyGenerator() {
    }

    public static <T extends Hierarchical<T>> HierarchyList<T> generateHierarchy(List<T> objList, ObjectId parentId, int rootCount, int childCount) {
        HierarchyList hierarchy = new HierarchyList();
        HashMap<Object, Hierarchical> map = new HashMap<Object, Hierarchical>();
        if (objList != null && objList.size() > 0) {
            for (Hierarchical obj : objList) {
                map.put(obj.getId(), obj);
                if (obj.getParentId() != parentId) continue;
                if (hierarchy.size() <= rootCount) {
                    hierarchy.add((Object)obj);
                    continue;
                }
                hierarchy.incExtraCount();
            }
            for (Hierarchical obj : objList) {
                Hierarchical parent;
                if (obj.getParentId() == parentId || (parent = (Hierarchical)map.get(obj.getParentId())) == null) continue;
                if (parent.getChildCount() <= childCount) {
                    parent.addChild((Object)obj);
                    continue;
                }
                parent.incExtraChildCount();
            }
        }
        return hierarchy;
    }
}

