/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.system.ContextPreferencesService;

public class SocialFreemarkerLoader
implements TemplateLoader {
    private ContextPreferencesService contextPreferencesService;

    public Object findTemplateSource(String name) throws IOException {
        String[] tmp = name.split("/");
        try {
            return this.contextPreferencesService.getNotificationEmailTemplate(tmp[0], tmp[1]);
        }
        catch (SocialException e) {
            throw new IOException("Unable to find Template " + name, e);
        }
    }

    public long getLastModified(Object templateSource) {
        return new Date().getTime();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new StringReader(templateSource.toString());
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    public void setContextPreferencesService(ContextPreferencesService contextPreferencesService) {
        this.contextPreferencesService = contextPreferencesService;
    }
}

