/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.ebus;

import freemarker.cache.TemplateLoader;
import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.craftercms.commons.ebus.annotations.EListener;
import org.craftercms.commons.ebus.annotations.EventHandler;
import org.craftercms.commons.ebus.annotations.EventSelectorType;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.SortOrder;
import org.craftercms.profile.api.VerificationToken;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.exceptions.SocialException;
import org.craftercms.social.services.system.ContextPreferencesService;
import org.craftercms.social.services.system.EmailService;
import org.craftercms.social.services.system.TenantConfigurationService;
import org.craftercms.social.util.ebus.SocialEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.event.Event;

@EListener
public class ApproveContentListener {
    private static final String APPROVER_EMAIL_TEMPLATE_NAME = "APPROVEREMAIL";
    private ProfileService profileService;
    private TenantConfigurationService tenantConfigurationService;
    private Logger logger = LoggerFactory.getLogger(ApproveContentListener.class);
    private TemplateLoader socialFreemarkerLoader;
    private Configuration cfg;
    private String systemDefaultLocale;
    private HashMap<String, Object> modelExt;
    private EmailService emailService;
    private ContextPreferencesService contextPreferencesService;

    @EventHandler(event="ugc.create", ebus="@socialReactor", type=EventSelectorType.REGEX)
    public void onAudit(Event<? extends SocialEvent> socialEvent) {
        SocialEvent event = (SocialEvent)socialEvent.getData();
        UGC ugc = event.getSource();
        boolean moderateByMail = Boolean.parseBoolean(this.tenantConfigurationService.getProperty(event.getSource().getContextId(), "moderateByMailEnable").toString());
        String moderateRole = (String)this.tenantConfigurationService.getProperty(event.getSource().getContextId(), "moderateByMailRole");
        String emailSubject = (String)this.tenantConfigurationService.getProperty(event.getSource().getContextId(), "moderateByMailSubject");
        if (moderateByMail) {
            try {
                Profile profile = this.profileService.getProfile(event.getUserId(), new String[0]);
                ugc.setUser(profile);
                if (profile != null) {
                    List toSendEmail = this.profileService.getProfilesByQuery(profile.getTenant(), "{\"attributes.socialContexts.id\":\"" + ugc.getContextId() + "\",\"attributes.socialContexts.roles\":{$in:[\"" + moderateRole + "\"]},enabled:true,\"attributes.socialContexts.id\":\"" + ugc.getContextId() + "\"}", "createdOn", SortOrder.ASC, Integer.valueOf(0), Integer.valueOf(999), new String[0]);
                    this.logger.debug("To Send emails {}", (Object)toSendEmail);
                    this.buildEmailToApprover(toSendEmail, ugc, emailSubject, (String)event.getAttribute("baseUrl"));
                }
            }
            catch (ProfileException e) {
                this.logger.error("Unable to get profiles information!", (Throwable)e);
            }
        }
    }

    private void buildEmailToApprover(List<Profile> toSendEmail, UGC ugc, String emailSubject, String baseUrl) {
        for (Profile profile : toSendEmail) {
            try {
                HashMap<String, Object> dataModel = new HashMap<String, Object>(this.modelExt);
                VerificationToken id = this.profileService.createVerificationToken(profile.getId().toString());
                dataModel.put("profile", profile);
                dataModel.put("ugc", ugc);
                dataModel.put("verificationToken", id);
                dataModel.put("baseUrl", baseUrl);
                Map contextPreferences = this.contextPreferencesService.getContextPreferences(ugc.getContextId());
                TimeZone timezone = TimeZone.getTimeZone(((HashMap)contextPreferences.get("preferences")).get("timezone").toString());
                this.cfg.setTimeZone(timezone);
                StringWriter writer = new StringWriter();
                Template template = this.cfg.getTemplate(ugc.getContextId() + "/APPROVEREMAIL", this.getProfileLocale(profile.getAttribute("notificationLocale")));
                Environment env = template.createProcessingEnvironment(dataModel, (Writer)writer);
                env.process();
                writer.flush();
                this.emailService.sendEmail(profile, writer, emailSubject, ugc.getContextId());
            }
            catch (ProfileException ex) {
                this.logger.error("Unable to generate Verification Token", (Throwable)ex);
            }
            catch (TemplateException | IOException ex) {
                this.logger.error("Unable to generate email template", ex);
            }
            catch (SocialException ex) {
                this.logger.error("Unable to Send email ", (Throwable)ex);
            }
            catch (Throwable ex) {
                this.logger.error("Unable to send email due a unknown exception", ex);
            }
        }
    }

    private Locale getProfileLocale(Object notificationLocale) {
        if (notificationLocale == null) {
            return new Locale(this.systemDefaultLocale);
        }
        return new Locale(notificationLocale.toString());
    }

    public void init() {
        this.cfg = new Configuration(Configuration.VERSION_2_3_21);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setOutputEncoding("UTF-8");
        this.cfg.setTemplateLoader(this.socialFreemarkerLoader);
    }

    public void setProfileClient(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setTenantConfigurationServiceImpl(TenantConfigurationService tenantConfigurationService) {
        this.tenantConfigurationService = tenantConfigurationService;
    }

    public void setSocialFreemarkerLoader(TemplateLoader socialFreemarkerLoader) {
        this.socialFreemarkerLoader = socialFreemarkerLoader;
    }

    public void setSystemDefaultLocale(String systemDefaultLocale) {
        this.systemDefaultLocale = systemDefaultLocale;
    }

    public void setModelExt(HashMap<String, Object> modelExt) {
        this.modelExt = modelExt;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public void setContextPreferencesService(ContextPreferencesService contextPreferencesService) {
        this.contextPreferencesService = contextPreferencesService;
    }
}

