/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.ebus;

import org.craftercms.commons.ebus.annotations.EListener;
import org.craftercms.commons.ebus.annotations.EventHandler;
import org.craftercms.commons.ebus.annotations.EventSelectorType;
import org.craftercms.social.domain.audit.AuditLog;
import org.craftercms.social.util.ebus.SocialEvent;
import reactor.core.Reactor;
import reactor.event.Event;

@EListener
public class AuditListener {
    private Reactor auditReactor;

    @EventHandler(event=".*", ebus="@socialReactor", type=EventSelectorType.REGEX)
    public void onAudit(Event<? extends SocialEvent> socialEvent) {
        SocialEvent event = (SocialEvent)socialEvent.getData();
        AuditLog auditLog = new AuditLog(event.getSource());
        auditLog.setContextId(event.getSource().getContextId());
        auditLog.setUserId(event.getUserId());
        auditLog.setActionName(socialEvent.getKey().toString());
        this.auditReactor.notify((Object)"crafterCommons.audit.Audit", Event.wrap((Object)auditLog));
    }

    public void setAuditReactor(Reactor auditReactor) {
        this.auditReactor = auditReactor;
    }
}

