/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.ebus;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.util.ebus.UGCEvent;

public class SocialEvent<T extends UGC> {
    private T source;
    private String ugcId;
    private Map<String, Object> attributes;
    private InputStream[] attachments;
    private String attachmentId;
    private String userId;
    private UGCEvent type;

    public SocialEvent(T source, String userId, UGCEvent type) {
        this.source = source;
        this.attributes = source.getAttributes();
        this.ugcId = source.getId().toString();
        this.userId = userId;
        this.type = type;
    }

    public SocialEvent(String ugcId, String userId, UGCEvent type) {
        this.ugcId = ugcId;
        this.userId = userId;
        this.type = type;
        this.attributes = new HashMap();
    }

    public SocialEvent(String ugcId, Map<String, Object> attributes, String userId, UGCEvent type) {
        this.ugcId = ugcId;
        this.attributes = attributes;
        this.userId = userId;
        this.type = type;
    }

    public SocialEvent(String ugcId, String attachmentId, String userId, UGCEvent type) {
        this.ugcId = ugcId;
        this.attachmentId = attachmentId;
        this.userId = userId;
        this.type = type;
        this.attributes = new HashMap();
    }

    public T getSource() {
        return (T)this.source;
    }

    public String getUgcId() {
        return this.ugcId;
    }

    public SocialEvent(String ugcId, InputStream[] attachments) {
        this.ugcId = ugcId;
        this.attachments = attachments;
    }

    public InputStream[] getAttachments() {
        return this.attachments;
    }

    public UGCEvent getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public <T> T getAttribute(String key) {
        return (T)this.attributes.get(key);
    }
}

