/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.profile;

import com.google.common.cache.Cache;
import java.util.List;
import org.craftercms.profile.api.Profile;
import org.craftercms.profile.api.exceptions.ProfileException;
import org.craftercms.profile.api.services.ProfileService;
import org.craftercms.social.util.profile.ProfileAggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileAggregatorImpl
implements ProfileAggregator {
    private ProfileService profileService;
    private Cache<String, Profile> cache;
    private Logger log = LoggerFactory.getLogger(ProfileAggregatorImpl.class);
    private String[] attributesToReturn;

    public void setAttributesToReturn(String[] attributesToReturn) {
        this.attributesToReturn = attributesToReturn;
    }

    public void clearProfileCache(List<String> profileIds) {
        for (String profileId : profileIds) {
            if (this.cache.getIfPresent((Object)profileId) == null) continue;
            try {
                this.cache.invalidate((Object)profileId);
                this.log.debug("Profile {} deleted from cache", (Object)profileId);
            }
            catch (IllegalStateException ex) {
                this.log.warn("Unable to remove profile " + profileId + " from cache ", (Throwable)ex);
            }
        }
    }

    public void clearProfileCache() {
        try {
            this.cache.invalidateAll();
        }
        catch (IllegalStateException ex) {
            this.log.warn("Unable to clear profile cache ", (Throwable)ex);
        }
    }

    public Profile getProfile(String profileId) {
        Profile profile = (Profile)this.cache.getIfPresent((Object)profileId);
        if (profile == null && (profile = this.getProfileFromServer(profileId)) != null) {
            this.cache.put((Object)profileId, (Object)profile);
        }
        return profile;
    }

    private Profile getProfileFromServer(String profileId) {
        try {
            Profile profile = this.profileService.getProfile(profileId, this.attributesToReturn);
            if (profile == null) {
                return null;
            }
            Profile toReturn = new Profile();
            toReturn.setId(profile.getId());
            toReturn.setUsername(profile.getUsername());
            toReturn.setEmail(profile.getEmail());
            toReturn.setAttributes(profile.getAttributes());
            return toReturn;
        }
        catch (ProfileException ex) {
            this.log.error("Unable to get profile \"" + profileId + "\"from server ", (Throwable)ex);
            return null;
        }
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setCache(Cache<String, Profile> cache) {
        this.cache = cache;
    }
}

