/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.serialization;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.commons.i10n.I10nLogger;
import org.craftercms.commons.jackson.mvc.annotations.InjectValueFactory;
import org.craftercms.profile.api.Profile;
import org.craftercms.social.domain.UGC;
import org.craftercms.social.security.SocialSecurityUtils;
import org.craftercms.social.services.notification.NotificationService;
import org.craftercms.social.util.LoggerFactory;
import org.craftercms.social.util.ProfileUtils;
import org.craftercms.social.util.profile.ProfileAggregator;

public class SocialInjectValueFactory
implements InjectValueFactory {
    protected ProfileAggregator profileAggregator;
    protected NotificationService notificationService;
    protected I10nLogger log = LoggerFactory.getLogger(SocialInjectValueFactory.class);
    protected String ignoreAnonymousFlagRoles;

    public <T> T getObjectFor(Class<T> declaringClass, Object basePropertyValue, String originalProperty, Object object) {
        if (UGC.class.isAssignableFrom(object.getClass()) && declaringClass.equals(Profile.class)) {
            Profile profile = this.profileAggregator.getProfile((String)basePropertyValue);
            if (((UGC)object).isAnonymousFlag() && !this.ignoreAnonymousFlag()) {
                this.anonymizeProfile((UGC)object);
                return (T)ProfileUtils.getAnonymousProfile();
            }
            return (T)profile;
        }
        return null;
    }

    private boolean ignoreAnonymousFlag() {
        Profile currentUser = SocialSecurityUtils.getCurrentProfile();
        if (currentUser == null || currentUser.getRoles().isEmpty() || currentUser.getUsername().equalsIgnoreCase("ANONYMOUS")) {
            return false;
        }
        return CollectionUtils.containsAny((Collection)currentUser.getRoles(), Arrays.asList(this.ignoreAnonymousFlagRoles.split(",")));
    }

    protected void anonymizeProfile(UGC object) {
        if (object.getCreatedBy().equals(object.getLastModifiedBy())) {
            object.setLastModifiedBy("");
        }
        object.setCreatedBy("");
    }

    public void setProfileAggregator(ProfileAggregator profileAggregator) {
        this.profileAggregator = profileAggregator;
    }

    public void setNotificationServiceImpl(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setIgnoreAnonymousFlagRoles(String ignoreAnonymousFlagRoles) {
        this.ignoreAnonymousFlagRoles = ignoreAnonymousFlagRoles;
    }
}

