/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.social.util.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UGCObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1669827811287238948L;
    private List<JsonSerializer> serializerList = new ArrayList();
    private Map<Class, JsonDeserializer> deserializerMap = new HashMap();

    @ConstructorProperties(value={"serializerList", "deserializerMap"})
    public UGCObjectMapper(List<JsonSerializer> serializerList, Map<Class, JsonDeserializer> deserializerMap) {
        super.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        super.getSerializationConfig().without(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        super.getSerializationConfig().with(SerializationFeature.WRITE_NULL_MAP_VALUES);
        this.serializerList = serializerList;
        this.deserializerMap = deserializerMap;
        this.registerSerializationModule();
    }

    protected void registerSerializationModule() {
        SimpleModule module = new SimpleModule("UGCSerializationModule", new Version(1, 0, 0, null, null, null));
        for (JsonSerializer ser : this.serializerList) {
            module.addSerializer(ser);
        }
        for (Class key : this.deserializerMap.keySet()) {
            JsonDeserializer deser = (JsonDeserializer)this.deserializerMap.get(key);
            module.addDeserializer(key, deser);
        }
        this.registerModule((Module)module);
    }

    public List<JsonSerializer> getSerializerList() {
        return this.serializerList;
    }

    public void setSerializerList(List<JsonSerializer> serializerList) {
        this.serializerList = serializerList;
    }

    public Map<Class, JsonDeserializer> getDeserializerMap() {
        return this.deserializerMap;
    }

    public void setDeserializerMap(Map<Class, JsonDeserializer> deserializerMap) {
        this.deserializerMap = deserializerMap;
    }
}

