/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.engine.exception.HttpStatusCodeException;
import org.craftercms.engine.http.HttpProxy;
import org.craftercms.engine.http.HttpProxyRegistry;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.HttpStatus;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.WebContentGenerator;

public class HttpProxyRequestHandler
extends WebContentGenerator
implements HttpRequestHandler {
    public static String PROXY_NAME_URI_TEMPLATE_VAR_NAME = "proxyName";
    private HttpProxyRegistry proxyRegistry;

    public HttpProxyRequestHandler() {
        super(new String[]{"GET", "POST"});
        this.setRequireSession(false);
    }

    @Required
    public void setProxyRegistry(HttpProxyRegistry proxyRegistry) {
        this.proxyRegistry = proxyRegistry;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.checkAndPrepare(request, response, false);
        String proxyName = this.getProxyNameUriTemplateVar(request);
        String proxyUrl = this.getUrlToProxy(request);
        HttpProxy proxy = (HttpProxy)this.proxyRegistry.get(proxyName);
        if (proxy == null) {
            throw new HttpStatusCodeException(HttpStatus.NOT_FOUND, "Proxy name '" + proxyName + "' in URL doesn't " + "correspond to a registered proxy");
        }
        if ("GET".equals(request.getMethod())) {
            proxy.proxyGet(proxyUrl, request, response);
        } else {
            proxy.proxyPost(proxyUrl, request, response);
        }
    }

    protected String getProxyNameUriTemplateVar(HttpServletRequest request) {
        Map uriTemplateVars = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        if (MapUtils.isEmpty((Map)uriTemplateVars)) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE + "' is not set");
        }
        String proxyName = (String)uriTemplateVars.get(PROXY_NAME_URI_TEMPLATE_VAR_NAME);
        if (StringUtils.isEmpty((String)proxyName)) {
            throw new IllegalStateException("Required URI template var '" + PROXY_NAME_URI_TEMPLATE_VAR_NAME + "' is not set");
        }
        return proxyName;
    }

    protected String getUrlToProxy(HttpServletRequest request) {
        String url = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        return url;
    }
}

