/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.util.ExceptionUtils;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.craftercms.engine.exception.ScriptException;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class PageRenderController
extends AbstractController {
    private static final Log logger = LogFactory.getLog(PageRenderController.class);
    private static final String SCRIPT_URL_FORMAT = "%s.%s.%s";
    protected String fallbackPageUrl;
    protected ContentStoreService storeService;

    @Required
    public void setFallbackPageUrl(String fallbackPageUrl) {
        this.fallbackPageUrl = fallbackPageUrl;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String pageUrl;
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            if (siteContext.isFallback()) {
                logger.warn((Object)("Rendering fallback page [" + this.fallbackPageUrl + "]"));
                pageUrl = this.fallbackPageUrl;
            } else {
                pageUrl = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
                if (StringUtils.isEmpty((CharSequence)pageUrl)) {
                    throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
                }
                Script controllerScript = this.getControllerScript(siteContext, request, pageUrl);
                if (controllerScript != null) {
                    HashMap<String, Object> model = new HashMap<String, Object>();
                    Map<String, Object> variables = this.createScriptVariables(request, response, model);
                    String viewName = this.executeScript(controllerScript, variables);
                    if (StringUtils.isNotEmpty((CharSequence)viewName)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Rendering view " + viewName + " returned by script " + controllerScript));
                        }
                        return new ModelAndView(viewName, model);
                    }
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Rendering page [" + pageUrl + "]"));
                }
            }
        } else {
            throw new IllegalStateException("No current site context found");
        }
        return new ModelAndView(pageUrl);
    }

    protected Script getControllerScript(SiteContext siteContext, HttpServletRequest request, String pageUrl) {
        ScriptFactory scriptFactory = siteContext.getScriptFactory();
        if (scriptFactory == null) {
            throw new IllegalStateException("No script factory associated to current site context '" + siteContext.getSiteName() + "'");
        }
        String scriptUrl = this.getScriptUrl(siteContext, scriptFactory, request, pageUrl);
        try {
            if (this.storeService.exists(siteContext.getContext(), scriptUrl)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Controller script found for page " + pageUrl + " at " + scriptUrl));
                }
                return scriptFactory.getScript(scriptUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No controller script for page " + pageUrl + " at " + scriptUrl));
            }
        }
        catch (CrafterException e) {
            logger.error((Object)("Error while trying to retrieve controller script at " + scriptUrl), (Throwable)e);
        }
        return null;
    }

    protected String getScriptUrl(SiteContext siteContext, ScriptFactory scriptFactory, HttpServletRequest request, String pageUrl) {
        String method = request.getMethod().toLowerCase();
        String pageUrlNoExt = FilenameUtils.removeExtension((String)pageUrl);
        String controllerScriptsPath = siteContext.getControllerScriptsPath();
        String baseUrl = UrlUtils.appendUrl((String)controllerScriptsPath, (String)pageUrlNoExt);
        return String.format(SCRIPT_URL_FORMAT, baseUrl, method, scriptFactory.getScriptFileExtension());
    }

    protected Map<String, Object> createScriptVariables(HttpServletRequest request, HttpServletResponse response, Map<String, Object> model) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        GroovyUtils.addCommonVariables(variables, request, response, this.getServletContext());
        GroovyUtils.addSecurityVariables(variables);
        GroovyUtils.addModelVariable(variables, model);
        return variables;
    }

    protected String executeScript(Script script, Map<String, Object> scriptVariables) throws Exception {
        try {
            Object result = script.execute(scriptVariables);
            if (result != null) {
                if (result instanceof String) {
                    return (String)result;
                }
                throw new ScriptException("Expected String view name as return value of controller script " + script + ". Actual type of returns value: " + result.getClass().getName());
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)("Error executing controller script at " + script.getUrl()), (Throwable)e);
            Exception cause = (Exception)ExceptionUtils.getThrowableOfType((Throwable)e, HttpStatusCodeAwareException.class);
            if (cause != null) {
                throw cause;
            }
            throw e;
        }
    }
}

