/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.http.MediaType;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.support.WebContentGenerator;

public class StaticAssetsRequestHandler
extends WebContentGenerator
implements HttpRequestHandler {
    private static final Log logger = LogFactory.getLog(StaticAssetsRequestHandler.class);
    private ContentStoreService contentStoreService;
    private String staticAssetsPath;
    private boolean disableCaching;

    public StaticAssetsRequestHandler() {
        super(new String[]{"GET", "HEAD"});
        this.setRequireSession(false);
    }

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Content content;
        this.checkAndPrepare(request, response, true);
        SiteContext siteContext = SiteContext.getCurrent();
        String path = this.getPath(request, siteContext);
        if (siteContext == null) {
            throw new IllegalStateException("No current site context found");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Trying to get content for static asset at [context=" + siteContext + ", path='" + path + "']"));
        }
        if ((content = this.getContent(siteContext, path)) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No static asset found at [context=" + siteContext + ", path='" + path + "'] - returning 404"));
            }
            response.sendError(404);
            return;
        }
        MediaType mediaType = this.getMediaType(path);
        if (mediaType != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Determined media type '" + mediaType + "' for static asset at [context=" + siteContext + ", path='" + path + "']"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No media type found for static asset at [context=" + siteContext + ", path='" + path + "'] - not sending a content-type header"));
        }
        if (new ServletWebRequest(request, response).checkNotModified(content.getLastModified())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Static asset not modified - returning 304");
            }
            return;
        }
        this.setHeaders(response, content, mediaType);
        if (this.disableCaching) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Caching disabled on client");
            }
            HttpUtils.disableCaching((HttpServletResponse)response);
        }
        if ("HEAD".equals(request.getMethod())) {
            logger.trace((Object)"HEAD request - skipping content");
            return;
        }
        this.writeContent(response, content);
    }

    protected String getPath(HttpServletRequest request, SiteContext siteContext) {
        String path = (String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE);
        if (StringUtils.isEmpty((String)path)) {
            throw new IllegalStateException("Required request attribute '" + HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE + "' is not set");
        }
        if (StringUtils.isNotEmpty((String)this.staticAssetsPath)) {
            return UrlUtils.appendUrl((String)this.staticAssetsPath, (String)path);
        }
        return UrlUtils.appendUrl((String)siteContext.getStaticAssetsPath(), (String)path);
    }

    protected Content getContent(SiteContext siteContext, String path) {
        try {
            return this.contentStoreService.getContent(siteContext.getContext(), path);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    protected MediaType getMediaType(String path) {
        String mimeType = this.getServletContext().getMimeType(FilenameUtils.getName((String)path));
        return StringUtils.isNotEmpty((String)mimeType) ? MediaType.parseMediaType((String)mimeType) : null;
    }

    protected void setHeaders(HttpServletResponse response, Content content, MediaType mediaType) throws IOException {
        response.setContentLength((int)content.getLength());
        if (mediaType != null) {
            response.setContentType(mediaType.toString());
        }
    }

    protected void writeContent(HttpServletResponse response, Content content) throws IOException {
        FileCopyUtils.copy((InputStream)content.getInputStream(), (OutputStream)response.getOutputStream());
    }
}

