/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.util.ExceptionUtils;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.exception.HttpStatusCodeAwareException;
import org.craftercms.engine.exception.ScriptNotFoundException;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class RestScriptsController
extends AbstractController {
    private static final Log logger = LogFactory.getLog(RestScriptsController.class);
    public static final String DEFAULT_RESPONSE_BODY_MODEL_ATTR_NAME = "responseBody";
    public static final String DEFAULT_ERROR_MESSAGE_MODEL_ATTR_NAME = "message";
    private static final String SCRIPT_URL_FORMAT = "%s.%s.%s";
    protected String responseBodyModelAttributeName = "responseBody";
    protected String errorMessageModelAttributeName = "message";

    public void setResponseBodyModelAttributeName(String responseBodyModelAttributeName) {
        this.responseBodyModelAttributeName = responseBodyModelAttributeName;
    }

    public void setErrorMessageModelAttributeName(String errorMessageModelAttributeName) {
        this.errorMessageModelAttributeName = errorMessageModelAttributeName;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        SiteContext siteContext = SiteContext.getCurrent();
        ScriptFactory scriptFactory = siteContext.getScriptFactory();
        if (scriptFactory == null) {
            throw new IllegalStateException("No script factory associate to current site context '" + siteContext.getSiteName() + "'");
        }
        String serviceUrl = this.getServiceUrl(request);
        String scriptUrl = this.getScriptUrl(scriptFactory, siteContext, request, serviceUrl);
        Object responseBody = this.executeScript(scriptFactory, request, response, scriptUrl);
        if (response.isCommitted()) {
            logger.debug((Object)("Response already committed by script " + scriptUrl));
            return null;
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject(this.responseBodyModelAttributeName, responseBody);
        return modelAndView;
    }

    protected String getServiceUrl(HttpServletRequest request) {
        String pathWithinHandlerMappingAttr = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        String url = (String)request.getAttribute(pathWithinHandlerMappingAttr);
        if (StringUtils.isEmpty((String)url)) {
            throw new IllegalStateException("Required request attribute '" + pathWithinHandlerMappingAttr + "' is not set");
        }
        return url;
    }

    protected String getScriptUrl(ScriptFactory scriptFactory, SiteContext siteContext, HttpServletRequest request, String serviceUrl) {
        String baseUrl = UrlUtils.appendUrl((String)siteContext.getRestScriptsPath(), (String)FilenameUtils.removeExtension((String)serviceUrl));
        return String.format(SCRIPT_URL_FORMAT, baseUrl, request.getMethod().toLowerCase(), scriptFactory.getScriptFileExtension());
    }

    protected Map<String, Object> createScriptVariables(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> scriptVariables = new HashMap<String, Object>();
        GroovyUtils.addCommonVariables(scriptVariables, request, response, this.getServletContext());
        GroovyUtils.addSecurityVariables(scriptVariables);
        return scriptVariables;
    }

    protected Object executeScript(ScriptFactory scriptFactory, HttpServletRequest request, HttpServletResponse response, String scriptUrl) {
        Map<String, Object> scriptVariables = this.createScriptVariables(request, response);
        try {
            return scriptFactory.getScript(scriptUrl).execute(scriptVariables);
        }
        catch (ScriptNotFoundException e) {
            logger.error((Object)("Script not found at " + scriptUrl), (Throwable)((Object)e));
            response.setStatus(400);
            return Collections.singletonMap(this.errorMessageModelAttributeName, "REST script not found");
        }
        catch (Exception e) {
            String errorMsg;
            logger.error((Object)("Error executing REST script at " + scriptUrl), (Throwable)e);
            HttpStatusCodeAwareException cause = (HttpStatusCodeAwareException)ExceptionUtils.getThrowableOfType((Throwable)e, HttpStatusCodeAwareException.class);
            if (cause != null) {
                response.setStatus(cause.getStatusCode());
                errorMsg = ((Exception)((Object)cause)).getMessage();
            } else {
                response.setStatus(500);
                errorMsg = e.getMessage();
            }
            return Collections.singletonMap(this.errorMessageModelAttributeName, errorMsg);
        }
    }
}

