/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.controller.rest;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/1/site/context"})
public class SiteContextRestController {
    public static final String URL_ROOT = "/site/context";
    public static final String URL_CONTEXT_ID = "/id";
    public static final String URL_DESTROY = "/destroy";
    public static final String URL_REBUILD = "/rebuild";
    public static final String MODEL_ATTR_ID = "id";
    private SiteContextManager contextRegistry;

    @Required
    public void setContextRegistry(SiteContextManager contextRegistry) {
        this.contextRegistry = contextRegistry;
    }

    @RequestMapping(value={"/id"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> getContextId() {
        return Collections.singletonMap(MODEL_ATTR_ID, SiteContext.getCurrent().getContext().getId());
    }

    @RequestMapping(value={"/destroy"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> destroy() {
        String siteName = SiteContext.getCurrent().getSiteName();
        this.contextRegistry.destroyContext(siteName);
        return Collections.singletonMap("message", "Site context for '" + siteName + "' destroyed. Will be recreated on next " + "request");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/rebuild"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> rebuild() {
        Lock lock = this.contextRegistry.getLock();
        SiteContext siteContext = SiteContext.getCurrent();
        String siteName = siteContext.getSiteName();
        boolean fallback = siteContext.isFallback();
        lock.lock();
        try {
            this.contextRegistry.destroyContext(siteName);
            siteContext = this.contextRegistry.getContext(siteName, fallback);
            SiteContext.setCurrent(siteContext);
            Map<String, String> map = Collections.singletonMap("message", "Site context for '" + siteName + "' rebuilt");
            return map;
        }
        finally {
            lock.unlock();
        }
    }
}

