/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import org.craftercms.engine.macro.MacroResolver;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class CrafterFreeMarkerConfigurer
extends FreeMarkerConfigurer {
    private MacroResolver macroResolver;
    private TemplateExceptionHandler templateExceptionHandler;
    private CacheStorage cacheStorage;

    public void setMacroResolver(MacroResolver macroResolver) {
        this.macroResolver = macroResolver;
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        this.templateExceptionHandler = templateExceptionHandler;
    }

    public void setCacheStorage(CacheStorage cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    protected void postProcessConfiguration(Configuration config) throws IOException, TemplateException {
        if (this.templateExceptionHandler != null) {
            config.setTemplateExceptionHandler(this.templateExceptionHandler);
        }
        if (this.cacheStorage != null) {
            config.setCacheStorage(this.cacheStorage);
        }
    }

    protected TemplateLoader getTemplateLoaderForPath(String templateLoaderPath) {
        if (this.macroResolver != null) {
            templateLoaderPath = this.macroResolver.resolveMacros(templateLoaderPath);
        }
        return super.getTemplateLoaderForPath(templateLoaderPath);
    }
}

