/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.PathNotFoundException;
import org.craftercms.core.service.Content;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.service.context.SiteContext;
import org.springframework.beans.factory.annotation.Required;

public class CrafterFreeMarkerTemplateLoader
implements TemplateLoader {
    private static final Log logger = LogFactory.getLog(CrafterFreeMarkerTemplateLoader.class);
    private ContentStoreService contentStoreService;

    @Required
    public void setContentStoreService(ContentStoreService contentStoreService) {
        this.contentStoreService = contentStoreService;
    }

    public Object findTemplateSource(String name) throws IOException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            String path = this.getTemplatePath(siteContext, name);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for FreeMarker template at [context=" + siteContext + ", path='" + path + "']"));
            }
            try {
                return this.contentStoreService.getContent(siteContext.getContext(), path);
            }
            catch (PathNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to find FreeMarker template at [context=" + siteContext + ", path='" + path + "']"));
                }
                return null;
            }
        }
        return null;
    }

    public long getLastModified(Object templateSource) {
        return ((Content)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new InputStreamReader(((Content)templateSource).getInputStream(), encoding);
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    protected String getTemplatePath(SiteContext siteContext, String name) {
        return UrlUtils.appendUrl((String)siteContext.getTemplatesPath(), (String)name);
    }
}

