/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.scripting.Script;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptResolver;
import org.craftercms.engine.service.SiteItemService;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyUtils;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;

public class RenderComponentDirective
implements TemplateDirectiveModel {
    private static final Log logger = LogFactory.getLog(RenderComponentDirective.class);
    public static final String KEY_COMPONENT_MODEL = "model";
    public static final String COMPONENT_PARAM_NAME = "component";
    public static final String COMPONENT_PATH_PARAM_NAME = "componentPath";
    protected ServletContext servletContext;
    protected SiteItemService siteItemService;
    protected ObjectFactory<SimpleHash> modelFactory;
    protected String templateXPathQuery;
    protected String templateNamePrefix;
    protected String templateNameSuffix;
    protected String includeElementName;
    protected ScriptResolver scriptResolver;

    @Required
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Required
    public void setSiteItemService(SiteItemService siteItemService) {
        this.siteItemService = siteItemService;
    }

    @Required
    public void setModelFactory(ObjectFactory<SimpleHash> modelFactory) {
        this.modelFactory = modelFactory;
    }

    @Required
    public void setTemplateXPathQuery(String templateXPathQuery) {
        this.templateXPathQuery = templateXPathQuery;
    }

    @Required
    public void setTemplateNamePrefix(String templateNamePrefix) {
        this.templateNamePrefix = templateNamePrefix;
    }

    @Required
    public void setTemplateNameSuffix(String templateNameSuffix) {
        this.templateNameSuffix = templateNameSuffix;
    }

    @Required
    public void setIncludeElementName(String includeElementName) {
        this.includeElementName = includeElementName;
    }

    @Required
    public void setScriptResolver(ScriptResolver scriptResolver) {
        this.scriptResolver = scriptResolver;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException {
        TemplateModel componentParam = (TemplateModel)params.get(COMPONENT_PARAM_NAME);
        TemplateModel componentPathParam = (TemplateModel)params.get(COMPONENT_PATH_PARAM_NAME);
        if (componentParam == null && componentPathParam == null) {
            throw new TemplateException("No 'component' or 'componentPath' param specified", env);
        }
        SiteItem component = componentParam != null ? this.getComponentFromNode(componentParam, env) : this.getComponentFromPath(componentPathParam, env);
        Map<String, Object> scriptsModel = this.executeScripts(component, env);
        SimpleHash model = this.getComponentModel(component, scriptsModel);
        Template template = this.getComponentTemplate(component, env);
        Writer output = env.getOut();
        this.processComponentTemplate(template, model, output, env);
    }

    protected SiteItem getComponentFromNode(TemplateModel componentParam, Environment env) throws TemplateException {
        Object unwrappedComponentParam = DeepUnwrap.unwrap((TemplateModel)componentParam);
        if (!(unwrappedComponentParam instanceof Node)) {
            throw new TemplateException("Param 'component of unexpected type: expected: " + Node.class.getName() + ", actual: " + unwrappedComponentParam.getClass().getName(), env);
        }
        Element includeElement = ((Element)unwrappedComponentParam).element(this.includeElementName);
        String componentUrl = includeElement.getTextTrim();
        return this.getComponent(componentUrl, env);
    }

    protected SiteItem getComponentFromPath(TemplateModel componentPathParam, Environment env) throws TemplateException {
        Object unwrappedComponentPathParam = DeepUnwrap.unwrap((TemplateModel)componentPathParam);
        if (!(unwrappedComponentPathParam instanceof String)) {
            throw new TemplateException("Param 'componentPath of unexpected type: expected: " + String.class.getName() + ", actual: " + unwrappedComponentPathParam.getClass().getName(), env);
        }
        return this.getComponent((String)unwrappedComponentPathParam, env);
    }

    protected SiteItem getComponent(String componentPath, Environment env) throws TemplateException {
        SiteItem component;
        Object unwrappedCurrentPage = DeepUnwrap.unwrap((TemplateModel)env.getVariable(KEY_COMPONENT_MODEL));
        if (unwrappedCurrentPage != null && unwrappedCurrentPage instanceof SiteItem) {
            SiteItem currentPage = (SiteItem)unwrappedCurrentPage;
            try {
                componentPath = UrlUtils.resolveRelative((String)currentPage.getStoreUrl(), (String)componentPath);
            }
            catch (URISyntaxException e) {
                throw new TemplateException("Invalid relative component URL " + componentPath, (Exception)e, env);
            }
        }
        try {
            component = this.siteItemService.getSiteItem(componentPath);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to load component " + componentPath + " from the underlying repository", e, env);
        }
        if (component == null) {
            throw new TemplateException("No component found at path '" + componentPath + "'", env);
        }
        return component;
    }

    protected Map<String, Object> executeScripts(SiteItem component, Environment env) throws TemplateException {
        List<String> scriptUrls = this.scriptResolver.getScriptUrls(component);
        if (CollectionUtils.isNotEmpty(scriptUrls)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Scripts associated to component " + component.getStoreUrl() + ": " + scriptUrls));
            }
            HashMap<String, Object> model = new HashMap<String, Object>();
            Map<String, Object> scriptVariables = this.createScriptVariables(component, model);
            SiteContext siteContext = SiteContext.getCurrent();
            if (siteContext != null) {
                ScriptFactory scriptFactory = siteContext.getScriptFactory();
                if (scriptFactory == null) {
                    throw new IllegalStateException("No script factory associate to current site context '" + siteContext.getSiteName() + "'");
                }
                for (String scriptUrl : scriptUrls) {
                    Script script;
                    try {
                        script = scriptFactory.getScript(scriptUrl);
                    }
                    catch (Exception e) {
                        throw new TemplateException("Unable to load script at '" + scriptUrl + "'", e, env);
                    }
                    this.executeScript(script, scriptVariables, env);
                }
            } else {
                throw new IllegalStateException("No current site context found");
            }
            return model;
        }
        return null;
    }

    protected Map<String, Object> createScriptVariables(SiteItem component, Map<String, Object> model) {
        HashMap<String, Object> scriptVariables = new HashMap<String, Object>();
        RequestContext context = RequestContext.getCurrent();
        GroovyUtils.addCommonVariables(scriptVariables, context.getRequest(), context.getResponse(), this.servletContext);
        GroovyUtils.addSecurityVariables(scriptVariables);
        GroovyUtils.addCrafterModelVariable(scriptVariables, component);
        GroovyUtils.addModelVariable(scriptVariables, model);
        return scriptVariables;
    }

    protected void executeScript(Script script, Map<String, Object> scriptVariables, Environment env) throws TemplateException {
        try {
            script.execute(scriptVariables);
        }
        catch (Exception e) {
            throw new TemplateException("Error executing component script at " + script.getUrl(), e, env);
        }
    }

    protected Template getComponentTemplate(SiteItem component, Environment env) throws TemplateException {
        try {
            return env.getTemplateForInclusion(this.getComponentTemplateName(component, env), null, true);
        }
        catch (IOException e) {
            throw new TemplateException("Unable to retrieve component template", (Exception)e, env);
        }
    }

    protected String getComponentTemplateName(SiteItem component, Environment env) throws TemplateException {
        String componentTemplateName = component.getItem().queryDescriptorValue(this.templateXPathQuery);
        if (StringUtils.isNotEmpty((String)componentTemplateName)) {
            return this.templateNamePrefix + componentTemplateName + this.templateNameSuffix;
        }
        throw new TemplateException("No component template defined in " + component, env);
    }

    protected SimpleHash getComponentModel(SiteItem component, Map<String, Object> scriptsModel) throws TemplateException {
        SimpleHash componentModel = (SimpleHash)this.modelFactory.getObject();
        componentModel.put(KEY_COMPONENT_MODEL, (Object)component);
        if (MapUtils.isNotEmpty(scriptsModel)) {
            componentModel.putAll(scriptsModel);
        }
        return componentModel;
    }

    protected void processComponentTemplate(Template template, SimpleHash model, Writer output, Environment env) throws TemplateException {
        try {
            template.process((Object)model, output);
        }
        catch (IOException e) {
            throw new TemplateException("I/O exception while processing the component template", (Exception)e, env);
        }
    }
}

