/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.http.impl;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.http.impl.HttpProxyImpl;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.MultiValueMap;

public class AlfrescoHttpProxy
extends HttpProxyImpl {
    private static final Log logger = LogFactory.getLog(AlfrescoHttpProxy.class);
    private String alfrescoTicketCookieName;

    @Required
    public void setAlfrescoTicketCookieName(String alfrescoTicketCookieName) {
        this.alfrescoTicketCookieName = alfrescoTicketCookieName;
    }

    @Override
    protected String createTargetQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String alfTicket = this.getCurrentTicket(request);
        if (queryString == null) {
            queryString = "";
        }
        if (alfTicket != null) {
            MultiValueMap queryParams = HttpUtils.getParamsFromQueryString((String)queryString);
            queryParams.set((Object)"alf_ticket", (Object)alfTicket);
            try {
                queryString = HttpUtils.getQueryStringFromParams((MultiValueMap)queryParams, (String)"UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)("Unable to encode params " + queryParams + " into a query string"), (Throwable)e);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("'" + this.alfrescoTicketCookieName + "' cookie not specified. Proxy request will be " + "generated without it"));
            }
            if (StringUtils.isNotEmpty((String)queryString)) {
                queryString = "?" + queryString;
            }
        }
        return queryString;
    }

    protected String getCurrentTicket(HttpServletRequest request) {
        return HttpUtils.getCookieValue((String)this.alfrescoTicketCookieName, (HttpServletRequest)request);
    }
}

