/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.http.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.exception.HttpProxyException;
import org.craftercms.engine.http.HttpProxy;
import org.springframework.beans.factory.annotation.Required;

public class HttpProxyImpl
implements HttpProxy {
    private static final Log logger = LogFactory.getLog(HttpProxyImpl.class);
    private String baseServiceUrl;
    private HttpClient httpClient = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());

    @Required
    public void setBaseServiceUrl(String baseServiceUrl) {
        this.baseServiceUrl = StringUtils.stripEnd((String)baseServiceUrl, (String)"/");
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public void proxyGet(String url, HttpServletRequest request, HttpServletResponse response) throws HttpProxyException {
        this.proxyMethod(url, true, request, response);
    }

    @Override
    public void proxyPost(String url, HttpServletRequest request, HttpServletResponse response) {
        this.proxyMethod(url, false, request, response);
    }

    protected void proxyMethod(String url, boolean isGet, HttpServletRequest request, HttpServletResponse response) throws HttpProxyException {
        url = this.createTargetUrl(url, request);
        HttpMethod httpMethod = null;
        try {
            httpMethod = isGet ? this.createGetMethod(url, request) : this.createPostMethod(url, request);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Proxying to " + this.getMethodDescription(httpMethod)));
            }
            int status = this.httpClient.executeMethod(httpMethod);
            response.setStatus(status);
            if (status >= 400 && logger.isDebugEnabled()) {
                logger.debug((Object)("Received error response from " + this.getMethodDescription(httpMethod) + ": status = " + httpMethod.getStatusText() + ", response body = \n" + httpMethod.getResponseBodyAsString()));
            }
            this.copyMethodResponseHeadersToResponse(httpMethod, response);
            this.copyMethodResponseBodyToResponse(httpMethod, response);
        }
        catch (Exception e) {
            String errorMsg = httpMethod != null ? "Error while proxying to " + this.getMethodDescription(httpMethod) : "Error while proxing to " + (isGet ? "GET[" : "POST[") + url + "]";
            logger.error((Object)errorMsg, (Throwable)e);
            throw new HttpProxyException(errorMsg, e);
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
    }

    protected HttpMethod createGetMethod(String url, HttpServletRequest request) {
        GetMethod getMethod = new GetMethod(url);
        this.copyRequestHeadersToMethod((HttpMethod)getMethod, request);
        return getMethod;
    }

    protected HttpMethod createPostMethod(String url, HttpServletRequest request) throws IOException {
        PostMethod postMethod = new PostMethod(url);
        this.copyRequestHeadersToMethod((HttpMethod)postMethod, request);
        this.copyRequestBodyToMethod(postMethod, request);
        return postMethod;
    }

    protected void copyRequestHeadersToMethod(HttpMethod httpMethod, HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = request.getHeader(headerName);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this.getMethodDescription(httpMethod) + " copying request header " + headerName + ": " + headerValue));
                }
                httpMethod.addRequestHeader(headerName, headerValue);
            }
        }
    }

    protected void copyRequestBodyToMethod(PostMethod httpMethod, HttpServletRequest request) throws IOException {
        int contentLength = request.getContentLength();
        if (contentLength > 0) {
            String contentType = request.getContentType();
            ServletInputStream content = request.getInputStream();
            httpMethod.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)content, (long)contentLength, contentType));
        }
    }

    protected void copyMethodResponseHeadersToResponse(HttpMethod httpMethod, HttpServletResponse response) {
        Header[] headers;
        for (Header header : headers = httpMethod.getResponseHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            if (headerName.equals("Transfer-Encoding") || header.equals((Object)"chunked")) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this.getMethodDescription(httpMethod) + " copying response header " + headerName + ": " + headerValue));
            }
            if (response.containsHeader(headerName)) {
                response.setHeader(headerName, headerValue);
                continue;
            }
            response.addHeader(headerName, headerValue);
        }
    }

    protected void copyMethodResponseBodyToResponse(HttpMethod httpMethod, HttpServletResponse response) throws IOException {
        byte[] responseBody = httpMethod.getResponseBody();
        if (responseBody != null) {
            response.setContentLength(responseBody.length);
            ServletOutputStream out = response.getOutputStream();
            out.write(responseBody);
            out.flush();
        }
    }

    protected String createTargetUrl(String url, HttpServletRequest request) {
        StringBuilder targetUrl = new StringBuilder();
        if (!url.startsWith(this.baseServiceUrl)) {
            targetUrl.append(this.baseServiceUrl);
            if (!this.baseServiceUrl.endsWith("/") && !url.startsWith("/")) {
                targetUrl.append("/");
            }
        }
        targetUrl.append(url).append(this.createTargetQueryString(request));
        return targetUrl.toString();
    }

    protected String createTargetQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryString = "";
        }
        return queryString;
    }

    private String getMethodDescription(HttpMethod httpMethod) {
        try {
            return httpMethod.getName() + "[" + httpMethod.getURI() + "]";
        }
        catch (URIException e) {
            return httpMethod.getName() + "[" + httpMethod.getPath() + "]";
        }
    }
}

