/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.http.impl;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.http.ExceptionHandler;

public class ViewNotResolvedExceptionHandler
implements ExceptionHandler {
    private static final Log logger = LogFactory.getLog(ViewNotResolvedExceptionHandler.class);
    private static final Pattern viewNotResolvedMsgPattern = Pattern.compile("Could not resolve view with name '(.+)' in servlet with name '(.+)'");

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, Exception ex) throws IOException {
        Matcher viewNotResolvedMsgMatcher;
        if (ex instanceof ServletException && (viewNotResolvedMsgMatcher = viewNotResolvedMsgPattern.matcher(ex.getMessage())).matches()) {
            logger.warn((Object)("Resource '" + viewNotResolvedMsgMatcher.group(1) + "' not found"));
            response.sendError(404);
            return true;
        }
        return false;
    }
}

