/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.macro.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.macro.impl.AbstractMacro;
import org.springframework.beans.factory.annotation.Required;

public class CookieMacro
extends AbstractMacro {
    private static final Log logger = LogFactory.getLog(CookieMacro.class);
    private String cookieName;

    @Required
    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    protected String createMacroName() {
        return "{" + this.cookieName + "}";
    }

    @Override
    protected String getMacroValue(String str) {
        Cookie cookie;
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null && (cookie = HttpUtils.getCookie((String)this.cookieName, (HttpServletRequest)requestContext.getRequest())) != null) {
            return cookie.getValue();
        }
        return null;
    }
}

