/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.macro.impl;

import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.macro.impl.AbstractMacro;

public class RequestUriMacro
extends AbstractMacro {
    @Override
    protected String createMacroName() {
        return "{request.uri}";
    }

    @Override
    protected String getMacroValue(String str) {
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null) {
            String requestUri = requestContext.getRequest().getRequestURI();
            if (!requestUri.startsWith("/")) {
                requestUri = "/" + requestUri;
            }
            if (!requestUri.equals("/")) {
                requestUri = StringUtils.stripEnd((String)requestUri, (String)"/");
            }
            return requestUri;
        }
        return null;
    }
}

