/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.macro.impl;

import javax.servlet.http.HttpServletRequest;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.macro.impl.AbstractMacro;
import org.springframework.beans.factory.annotation.Required;

public class ScopeAttributeMacro
extends AbstractMacro {
    private String attributeName;
    private boolean requestScope = true;

    @Required
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setRequestScope(boolean requestScope) {
        this.requestScope = requestScope;
    }

    @Override
    protected String createMacroName() {
        return "{" + this.attributeName + "}";
    }

    @Override
    protected String getMacroValue(String str) {
        RequestContext requestContext = RequestContext.getCurrent();
        if (requestContext != null) {
            HttpServletRequest request = requestContext.getRequest();
            if (this.requestScope) {
                return (String)request.getAttribute(this.attributeName);
            }
            return (String)request.getSession().getAttribute(this.attributeName);
        }
        return null;
    }
}

