/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.model;

import freemarker.ext.util.ModelFactory;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.craftercms.engine.freemarker.CrafterObjectWrapper;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.Element;
import org.dom4j.Node;

public class Dom4jNodeModel
implements TemplateNodeModel,
TemplateSequenceModel,
TemplateHashModel,
AdapterTemplateModel,
TemplateScalarModel {
    public static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new Dom4jNodeModel((Node)object, wrapper);
        }
    };
    private Node node;
    private ObjectWrapper wrapper;

    public Dom4jNodeModel(Node node) {
        this.node = node;
        this.wrapper = new CrafterObjectWrapper();
    }

    public Dom4jNodeModel(Node node, ObjectWrapper wrapper) {
        this.node = node;
        this.wrapper = wrapper;
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return index == 0 ? this : null;
    }

    public int size() throws TemplateModelException {
        return 1;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object result = this.node.selectObject(key);
        if (result != null) {
            if (result instanceof Collection && ((Collection)result).isEmpty()) {
                return null;
            }
            return this.wrapper.wrap(result);
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.node.hasContent();
    }

    public TemplateNodeModel getParentNode() {
        Element parent = this.node.getParent();
        if (parent != null) {
            return new Dom4jNodeModel((Node)parent, this.wrapper);
        }
        return null;
    }

    public TemplateSequenceModel getChildNodes() throws TemplateModelException {
        if (this.node instanceof Branch) {
            List childNodes = ((Branch)this.node).content();
            if (childNodes != null) {
                return new SimpleSequence((Collection)childNodes, this.wrapper);
            }
            return null;
        }
        return new SimpleSequence(Collections.emptyList(), this.wrapper);
    }

    public String getNodeName() {
        return this.node.getName();
    }

    public String getNodeType() {
        return this.node.getNodeTypeName();
    }

    public String getNodeNamespace() {
        String namespaceUri = null;
        if (this.node instanceof Element) {
            namespaceUri = ((Element)this.node).getNamespaceURI();
        } else if (this.node instanceof Attribute) {
            namespaceUri = ((Attribute)this.node).getNamespaceURI();
        }
        return namespaceUri;
    }

    public Object getAdaptedObject(Class hint) {
        return this.node;
    }

    public String getAsString() throws TemplateModelException {
        return this.node.getText();
    }
}

