/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.Tree;
import org.craftercms.core.util.XmlUtils;
import org.craftercms.engine.model.converters.ModelValueConverter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class SiteItem {
    private static Log logger = LogFactory.getLog(SiteItem.class);
    protected Item item;
    protected List<SiteItem> childItems;
    protected Map<String, ModelValueConverter<?>> modelValueConverters;
    protected Comparator<SiteItem> sortComparator;

    public SiteItem(Item item, Map<String, ModelValueConverter<?>> modelValueConverters) {
        this.item = item;
        this.modelValueConverters = modelValueConverters;
    }

    public SiteItem(Item item, Map<String, ModelValueConverter<?>> modelValueConverters, Comparator<SiteItem> sortComparator) {
        this.item = item;
        this.modelValueConverters = modelValueConverters;
        this.sortComparator = sortComparator;
    }

    public Item getItem() {
        return this.item;
    }

    public String getStoreName() {
        return this.item.getName();
    }

    public String getStoreUrl() {
        return this.item.getUrl();
    }

    public boolean isFolder() {
        return this.item.isFolder();
    }

    public Document getDom() {
        return this.item.getDescriptorDom();
    }

    public Map<String, Object> getProperties() {
        return this.item.getProperties();
    }

    public Object get(String xPathQuery) {
        if (this.getDom() != null) {
            Object result = this.getDom().getRootElement().selectObject(xPathQuery);
            if (result != null && result instanceof Collection && ((Collection)result).isEmpty()) {
                result = null;
            }
            if (result instanceof Element) {
                return this.convertModelValue((Element)result);
            }
            return result;
        }
        return null;
    }

    public String queryValue(String xPathQuery) {
        if (this.getDom() != null) {
            return XmlUtils.selectSingleNodeValue((Node)this.getDom().getRootElement(), (String)xPathQuery);
        }
        return null;
    }

    public List<String> queryValues(String xPathQuery) {
        if (this.getDom() != null) {
            return XmlUtils.selectNodeValues((Node)this.getDom().getRootElement(), (String)xPathQuery);
        }
        return null;
    }

    public String queryValue(String xPathQuery, Map<String, String> namespaceUris) {
        if (this.getDom() != null) {
            return XmlUtils.selectSingleNodeValue((Node)this.getDom().getRootElement(), (String)xPathQuery, namespaceUris);
        }
        return null;
    }

    public List<String> queryValues(String xPathQuery, Map<String, String> namespaceUris) {
        if (this.getDom() != null) {
            return XmlUtils.selectNodeValues((Node)this.getDom().getRootElement(), (String)xPathQuery, namespaceUris);
        }
        return null;
    }

    public List<SiteItem> getChildItems() {
        if (this.childItems == null) {
            if (this.item instanceof Tree) {
                List treeChildren = ((Tree)this.item).getChildren();
                if (CollectionUtils.isNotEmpty((Collection)treeChildren)) {
                    this.childItems = new ArrayList<SiteItem>(treeChildren.size());
                    for (Item treeChild : treeChildren) {
                        this.childItems.add(new SiteItem(treeChild, this.modelValueConverters, this.sortComparator));
                    }
                    if (this.sortComparator != null) {
                        this.childItems = this.sortItems(this.childItems, this.sortComparator);
                    }
                } else {
                    this.childItems = Collections.emptyList();
                }
            } else {
                this.childItems = Collections.emptyList();
            }
        }
        return this.childItems;
    }

    public SiteItem getChildItem(String storeName) {
        for (SiteItem childItem : this.getChildItems()) {
            if (!childItem.getStoreName().equals(storeName)) continue;
            return childItem;
        }
        return null;
    }

    public String toString() {
        return "SiteItem[storeName='" + this.getStoreName() + '\'' + ", storeUrl='" + this.getStoreUrl() + '\'' + ", folder=" + this.isFolder() + ']';
    }

    protected List<SiteItem> sortItems(List<SiteItem> items, Comparator<SiteItem> comparator) {
        Collections.sort(items, comparator);
        return items;
    }

    protected Object convertModelValue(Element element) {
        String name = element.getName();
        int converterIdSuffixSepIdx = name.lastIndexOf("_");
        if (converterIdSuffixSepIdx >= 0) {
            String converterId = name.substring(converterIdSuffixSepIdx + 1);
            ModelValueConverter<?> converter = this.modelValueConverters.get(converterId);
            if (converter != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Converting value of <" + name + "> @ " + this + " with converter " + converter));
                }
                return converter.convert(element.getText());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No converter found for '" + converterId + "' (<" + name + "> @ " + this + ")"));
            }
        }
        return element;
    }
}

