/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import groovy.lang.Binding;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.craftercms.core.util.cache.impl.CachingAwareObjectBase;
import org.craftercms.engine.exception.ScriptException;
import org.craftercms.engine.exception.ScriptNotFoundException;
import org.craftercms.engine.scripting.Script;

public class GroovyScript
extends CachingAwareObjectBase
implements Script {
    protected GroovyScriptEngine scriptEngine;
    protected String scriptUrl;
    protected Map<String, Object> globalVariables;

    public GroovyScript(GroovyScriptEngine scriptEngine, String scriptUrl, Map<String, Object> globalVariables) {
        this.scriptEngine = scriptEngine;
        this.scriptUrl = scriptUrl;
        this.globalVariables = globalVariables;
    }

    @Override
    public String getUrl() {
        return this.scriptUrl;
    }

    @Override
    public Object execute(Map<String, Object> variables) throws ScriptException {
        HashMap<String, Object> allVariables = new HashMap<String, Object>();
        if (MapUtils.isNotEmpty(this.globalVariables)) {
            allVariables.putAll(this.globalVariables);
        }
        if (MapUtils.isNotEmpty(variables)) {
            allVariables.putAll(variables);
        }
        try {
            return this.scriptEngine.run(this.scriptUrl, new Binding(allVariables));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (e instanceof ResourceException && cause instanceof FileNotFoundException) {
                throw new ScriptNotFoundException(cause.getMessage(), cause);
            }
            throw new ScriptException(e.getMessage(), e);
        }
    }

    public String toString() {
        return "GroovyScript{scriptUrl='" + this.scriptUrl + '\'' + '}';
    }
}

