/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.scripting.impl;

import java.util.HashMap;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.GroovyUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScriptJob
implements Job {
    public static final String SITE_CONTEXT_DATA_KEY = "siteContext";
    public static final String SCRIPT_URL_DATA_KEY = "scriptUrl";

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String scriptUrl = dataMap.getString(SCRIPT_URL_DATA_KEY);
        SiteContext siteContext = (SiteContext)dataMap.get((Object)SITE_CONTEXT_DATA_KEY);
        ScriptFactory scriptFactory = siteContext.getScriptFactory();
        if (scriptFactory == null) {
            throw new JobExecutionException("No script factory associate to site context '" + siteContext.getSiteName() + "'");
        }
        SiteContext.setCurrent(siteContext);
        try {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            GroovyUtils.addJobVariables(variables);
            scriptFactory.getScript(scriptUrl).execute(variables);
        }
        catch (Exception e) {
            throw new JobExecutionException("Error executing script job at " + scriptUrl, (Throwable)e);
        }
        finally {
            SiteContext.clear();
        }
    }
}

