/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.security;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.commons.lang.Callback;
import org.craftercms.core.util.cache.CacheTemplate;
import org.craftercms.engine.exception.ConfigurationException;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.ConfigUtils;
import org.craftercms.security.processors.impl.UrlAccessRestrictionCheckingProcessor;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class ConfigAwareUrlAccessRestrictionCheckingProcessor
extends UrlAccessRestrictionCheckingProcessor {
    public static final String URL_RESTRICTION_KEY = "security.urlRestrictions.restriction";
    public static final String URL_RESTRICTION_URL_KEY = "url";
    public static final String URL_RESTRICTION_EXPRESSION_KEY = "expression";
    public static final String URL_RESTRICTIONS_CACHE_KEY = "urlRestrictions";
    protected CacheTemplate cacheTemplate;

    @Required
    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    protected Map<String, Expression> getUrlRestrictions() {
        Callback<Map<String, Expression>> callback = new Callback<Map<String, Expression>>(){

            public Map<String, Expression> execute() {
                List restrictionsConfig;
                HierarchicalConfiguration config = ConfigUtils.getCurrentConfig();
                LinkedHashMap<String, Expression> customRestrictions = null;
                if (config != null && CollectionUtils.isNotEmpty((Collection)(restrictionsConfig = config.configurationsAt(ConfigAwareUrlAccessRestrictionCheckingProcessor.URL_RESTRICTION_KEY)))) {
                    customRestrictions = new LinkedHashMap<String, Expression>(restrictionsConfig.size());
                    SpelExpressionParser parser = new SpelExpressionParser();
                    for (HierarchicalConfiguration restrictionConfig : restrictionsConfig) {
                        String url = restrictionConfig.getString(ConfigAwareUrlAccessRestrictionCheckingProcessor.URL_RESTRICTION_URL_KEY);
                        String expression = restrictionConfig.getString(ConfigAwareUrlAccessRestrictionCheckingProcessor.URL_RESTRICTION_EXPRESSION_KEY);
                        if (!StringUtils.isNotEmpty((CharSequence)url) || !StringUtils.isNotEmpty((CharSequence)expression)) continue;
                        try {
                            customRestrictions.put(url, parser.parseExpression(expression));
                        }
                        catch (ParseException e) {
                            throw new ConfigurationException(expression + " is not a valid SpEL expression", e);
                        }
                    }
                }
                if (customRestrictions != null) {
                    return customRestrictions;
                }
                return ConfigAwareUrlAccessRestrictionCheckingProcessor.this.urlRestrictions;
            }
        };
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return (Map)this.cacheTemplate.getObject(siteContext.getContext(), (Callback)callback, new Object[]{URL_RESTRICTIONS_CACHE_KEY});
        }
        return this.urlRestrictions;
    }
}

