/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.security;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.annotations.RunIfSecurityEnabled;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.exception.AccessDeniedException;
import org.craftercms.security.exception.AuthenticationRequiredException;
import org.craftercms.security.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Required;

public class CrafterPageAccessManager {
    protected String authorizedRolesXPathQuery;

    @Required
    public void setAuthorizedRolesXPathQuery(String authorizedRolesXPathQuery) {
        this.authorizedRolesXPathQuery = authorizedRolesXPathQuery;
    }

    @RunIfSecurityEnabled
    public void checkAccess(SiteItem page) throws AuthenticationRequiredException, AccessDeniedException {
        List<String> authorizedRoles;
        String pageUrl = page.getStoreUrl();
        Profile profile = null;
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        if (auth != null) {
            profile = auth.getProfile();
        }
        if (CollectionUtils.isNotEmpty(authorizedRoles = this.getAuthorizedRolesForPage(page)) && !this.containsRole("anonymous", authorizedRoles)) {
            if (profile == null) {
                throw new AuthenticationRequiredException("User is anonymous but page '" + pageUrl + "' requires authentication");
            }
            if (!this.containsRole("authenticated", authorizedRoles) && !profile.hasAnyRole(authorizedRoles)) {
                throw new AccessDeniedException("User '" + profile.getUsername() + "' is not authorized " + "to view page '" + pageUrl + "'");
            }
        }
    }

    protected List<String> getAuthorizedRolesForPage(SiteItem page) {
        return page.getItem().queryDescriptorValues(this.authorizedRolesXPathQuery);
    }

    protected boolean containsRole(String role, List<String> roles) {
        for (String r : roles) {
            if (!r.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }
}

