/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.security;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.security.PersonaAuthentication;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.processors.RequestSecurityProcessorChain;
import org.craftercms.security.processors.impl.CurrentAuthenticationResolvingProcessor;
import org.craftercms.security.utils.SecurityUtils;

public class PreviewCurrentAuthenticationResolvingProcessor
extends CurrentAuthenticationResolvingProcessor {
    private static final Log logger = LogFactory.getLog(PreviewCurrentAuthenticationResolvingProcessor.class);

    public void processRequest(RequestContext context, RequestSecurityProcessorChain processorChain) throws Exception {
        HttpServletRequest request = context.getRequest();
        Map attributes = (Map)request.getSession(true).getAttribute("_cr_profile_state");
        if (MapUtils.isNotEmpty((Map)attributes)) {
            if (!"anonymous".equalsIgnoreCase((String)attributes.get("username"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Non-anonymous persona set: " + attributes));
                }
                Profile profile = new Profile();
                profile.setUsername((String)attributes.get("username"));
                profile.setEnabled(true);
                profile.setCreatedOn(new Date());
                profile.setLastModified(new Date());
                profile.setTenant("preview");
                String rolesStr = (String)attributes.get("roles");
                if (rolesStr != null) {
                    String[] roles = rolesStr.split(",");
                    profile.getRoles().addAll(Arrays.asList(roles));
                }
                HashMap attributesNoUsernameNoRoles = new HashMap(attributes);
                attributesNoUsernameNoRoles.remove("username");
                attributesNoUsernameNoRoles.remove("roles");
                profile.setAttributes(attributesNoUsernameNoRoles);
                SecurityUtils.setAuthentication((HttpServletRequest)request, (Authentication)new PersonaAuthentication(profile));
                processorChain.processRequest(context);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Anonymous persona set. Trying to resolve authentication normally");
                }
                super.processRequest(context, processorChain);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No persona set. Trying to resolve authentication normally");
            }
            super.processRequest(context, processorChain);
        }
    }
}

