/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service;

import org.apache.commons.lang.StringUtils;
import org.craftercms.commons.http.RequestContext;
import org.craftercms.engine.macro.MacroResolver;
import org.craftercms.engine.mobile.UserAgentTemplateDetector;
import org.springframework.beans.factory.annotation.Required;

public class PreviewOverlayCallback {
    private String scriptFormat;
    private String[] previewServerJsScriptSources;
    private MacroResolver macroResolver;
    private UserAgentTemplateDetector userAgentTemplateDetector;

    @Required
    public void setScriptFormat(String scriptFormat) {
        this.scriptFormat = scriptFormat;
    }

    @Required
    public void setPreviewServerJsScriptSources(String[] previewServerJsScriptSources) {
        this.previewServerJsScriptSources = previewServerJsScriptSources;
    }

    @Required
    public void setMacroResolver(MacroResolver macroResolver) {
        this.macroResolver = macroResolver;
    }

    @Required
    public void setUserAgentTemplateDetector(UserAgentTemplateDetector userAgentTemplateDetector) {
        this.userAgentTemplateDetector = userAgentTemplateDetector;
    }

    public String render() {
        String queryString = RequestContext.getCurrent().getRequest().getQueryString();
        StringBuilder scriptsStr = new StringBuilder();
        if (StringUtils.isEmpty((String)queryString) || !queryString.contains(this.userAgentTemplateDetector.getAgentQueryStringParamName())) {
            for (String scriptSrc : this.previewServerJsScriptSources) {
                String script = this.scriptFormat.replace("{scriptSrc}", scriptSrc);
                scriptsStr.append(this.macroResolver.resolveMacros(script));
                scriptsStr.append(System.getProperty("line.separator"));
            }
        }
        return scriptsStr.toString();
    }
}

