/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Item;
import org.craftercms.core.service.ItemFilter;
import org.craftercms.core.service.Tree;
import org.craftercms.core.service.impl.CompositeItemFilter;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.model.converters.ModelValueConverter;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.filter.ExcludeByNameItemFilter;
import org.craftercms.engine.service.filter.ExpectedNodeValueItemFilter;
import org.craftercms.engine.service.filter.IncludeByNameItemFilter;
import org.springframework.beans.factory.annotation.Required;

public class SiteItemService {
    protected ContentStoreService storeService;
    protected Map<String, ModelValueConverter<?>> modelValueConverters;
    protected List<ItemFilter> defaultFilters;
    protected Comparator<SiteItem> sortComparator;

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setModelValueConverters(Map<String, ModelValueConverter<?>> modelValueConverters) {
        this.modelValueConverters = modelValueConverters;
    }

    public void setDefaultFilters(List<ItemFilter> defaultFilters) {
        this.defaultFilters = defaultFilters;
    }

    public void setSortComparator(Comparator<SiteItem> sortComparator) {
        this.sortComparator = sortComparator;
    }

    public SiteItem getSiteItem(String url) {
        SiteContext siteContext = SiteContext.getCurrent();
        Item item = this.storeService.findItem(siteContext.getContext(), url);
        if (item != null) {
            return new SiteItem(item, this.modelValueConverters);
        }
        return null;
    }

    public SiteItem getSiteTree(String url, int depth) {
        return this.getSiteTree(url, depth, null, null, null);
    }

    public SiteItem getSiteTree(String url, int depth, String includeByNameRegex, String excludeByNameRegex) {
        return this.getSiteTree(url, depth, includeByNameRegex, excludeByNameRegex, null);
    }

    public SiteItem getSiteTree(String url, int depth, String includeByNameRegex, String excludeByNameRegex, String[] ... nodeXPathAndExpectedValuePairs) {
        SiteContext siteContext;
        Tree tree;
        CompositeItemFilter compositeFilter = new CompositeItemFilter();
        if (CollectionUtils.isNotEmpty(this.defaultFilters)) {
            for (ItemFilter defaultFilter : this.defaultFilters) {
                compositeFilter.addFilter(defaultFilter);
            }
        }
        if (StringUtils.isNotEmpty((String)includeByNameRegex)) {
            compositeFilter.addFilter((ItemFilter)new IncludeByNameItemFilter(includeByNameRegex));
        }
        if (StringUtils.isNotEmpty((String)excludeByNameRegex)) {
            compositeFilter.addFilter((ItemFilter)new ExcludeByNameItemFilter(excludeByNameRegex));
        }
        if (ArrayUtils.isNotEmpty((Object[])nodeXPathAndExpectedValuePairs)) {
            for (String[] nodeXPathAndExpectedValuePair : nodeXPathAndExpectedValuePairs) {
                String nodeXPathQuery = nodeXPathAndExpectedValuePair[0];
                String expectedNodeValueRegex = nodeXPathAndExpectedValuePair[1];
                compositeFilter.addFilter((ItemFilter)new ExpectedNodeValueItemFilter(nodeXPathQuery, expectedNodeValueRegex));
            }
        }
        if ((tree = this.storeService.findTree((siteContext = SiteContext.getCurrent()).getContext(), null, url, depth, (ItemFilter)compositeFilter, null)) != null) {
            return new SiteItem((Item)tree, this.modelValueConverters, this.sortComparator);
        }
        return null;
    }
}

