/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service;

import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.engine.service.context.SiteContext;

public class UrlTransformationService {
    public String transform(String transformerName, String url) throws UrlTransformationException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            return siteContext.getUrlTransformationEngine().transformUrl(siteContext.getContext(), transformerName, url);
        }
        return url;
    }

    public String transform(String transformerName, String url, boolean cache) throws UrlTransformationException {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null) {
            CachingOptions cachingOptions = new CachingOptions();
            cachingOptions.setDoCaching(cache);
            return siteContext.getUrlTransformationEngine().transformUrl(siteContext.getContext(), cachingOptions, transformerName, url);
        }
        return url;
    }
}

