/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextManager;
import org.craftercms.engine.service.context.SiteContextResolver;
import org.springframework.beans.factory.annotation.Required;

public abstract class AbstractSiteContextResolver
implements SiteContextResolver {
    public static final String SITE_NAME_ATTRIBUTE = "siteName";
    private static final Log logger = LogFactory.getLog(AbstractSiteContextResolver.class);
    protected boolean createContextsOnStartup;
    protected SiteContextManager siteContextManager;
    protected String fallbackSiteName;

    @Required
    public void setCreateContextsOnStartup(boolean createContextsOnStartup) {
        this.createContextsOnStartup = createContextsOnStartup;
    }

    @Required
    public void setSiteContextManager(SiteContextManager siteContextManager) {
        this.siteContextManager = siteContextManager;
    }

    @Required
    public void setFallbackSiteName(String fallbackSiteName) {
        this.fallbackSiteName = fallbackSiteName;
    }

    @PostConstruct
    public void init() throws Exception {
        if (this.createContextsOnStartup) {
            this.createContextsForNewSites(this.getSiteList());
        }
    }

    public void refreshContexts() {
        Collection<String> siteNames = this.getSiteList();
        this.destroyContextsForRemovedSites(siteNames);
        this.createContextsForNewSites(siteNames);
    }

    @Override
    public SiteContext getContext(HttpServletRequest request) {
        String siteName = StringUtils.lowerCase((String)this.getSiteName(request));
        boolean fallback = false;
        if (StringUtils.isNotEmpty((CharSequence)siteName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Site name resolved for current request: '" + siteName + "'"));
            }
        } else {
            siteName = this.fallbackSiteName;
            fallback = true;
            logger.warn((Object)"Unable to resolve a site name for the request. Using fallback site");
        }
        request.setAttribute(SITE_NAME_ATTRIBUTE, (Object)siteName);
        return this.getContext(siteName, fallback);
    }

    protected void createContextsForNewSites(Collection<String> siteNames) {
        logger.info((Object)"==================================================");
        logger.info((Object)"<CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            for (String siteName : siteNames) {
                try {
                    this.siteContextManager.createContext(siteName, false);
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to create site context for site '" + siteName + "'"), (Throwable)e);
                }
            }
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</CREATING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    protected void destroyContextsForRemovedSites(Collection<String> siteNames) {
        logger.info((Object)"==================================================");
        logger.info((Object)"<DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
        if (CollectionUtils.isNotEmpty(siteNames)) {
            ArrayList<SiteContext> contextsToDestroy = new ArrayList<SiteContext>();
            for (SiteContext siteContext : this.siteContextManager.listContexts()) {
                String siteName = siteContext.getSiteName();
                if (siteName.equals(this.fallbackSiteName) || siteNames.contains(siteName)) continue;
                contextsToDestroy.add(siteContext);
            }
            for (SiteContext siteContext : contextsToDestroy) {
                this.siteContextManager.destroyContext(siteContext.getSiteName());
            }
        } else {
            this.siteContextManager.destroyAllContexts();
        }
        logger.info((Object)"==================================================");
        logger.info((Object)"</DESTROYING SITE CONTEXTS>");
        logger.info((Object)"==================================================");
    }

    protected SiteContext getContext(String siteName, boolean fallback) {
        SiteContext siteContext = this.siteContextManager.getContext(siteName, fallback);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Site context resolved for current request: " + siteContext));
        }
        return siteContext;
    }

    protected abstract Collection<String> getSiteList();

    protected abstract String getSiteName(HttpServletRequest var1);
}

