/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.service.context.AbstractSiteContextResolver;
import org.craftercms.engine.service.context.SiteListResolver;
import org.springframework.beans.factory.annotation.Required;

public class CookieSiteContextResolver
extends AbstractSiteContextResolver {
    private static final Log logger = LogFactory.getLog(CookieSiteContextResolver.class);
    protected SiteListResolver siteListResolver;
    protected String paramOrCookieName;

    @Required
    public void setSiteListResolver(SiteListResolver siteListResolver) {
        this.siteListResolver = siteListResolver;
    }

    @Required
    public void setParamOrCookieName(String paramOrCookieName) {
        this.paramOrCookieName = paramOrCookieName;
    }

    @Override
    protected Collection<String> getSiteList() {
        return this.siteListResolver.getSiteList();
    }

    @Override
    protected String getSiteName(HttpServletRequest request) {
        String siteName = request.getParameter(this.paramOrCookieName);
        if (StringUtils.isEmpty((CharSequence)siteName) && StringUtils.isEmpty((CharSequence)(siteName = HttpUtils.getCookieValue((String)this.paramOrCookieName, (HttpServletRequest)request)))) {
            logger.warn((Object)("No '" + this.paramOrCookieName + "' request param or cookie found"));
        }
        return siteName;
    }
}

