/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.exception.CrafterException;
import org.craftercms.engine.service.context.AbstractSiteContextResolver;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class ReloadableMappingsSiteContextResolver
extends AbstractSiteContextResolver {
    private static final Log logger = LogFactory.getLog(ReloadableMappingsSiteContextResolver.class);
    protected Resource mappingsFile;
    protected volatile Properties mappings;

    @Required
    public void setMappingsFile(Resource mappingsFile) {
        this.mappingsFile = mappingsFile;
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        this.loadMappings();
        super.init();
    }

    public synchronized void reloadMappings() throws CrafterException {
        this.loadMappings();
        this.refreshContexts();
    }

    @Override
    protected Collection<String> getSiteList() {
        Collection<Object> siteNames = this.mappings.values();
        LinkedHashSet<String> result = new LinkedHashSet<String>(siteNames.size());
        for (Object siteName : siteNames) {
            result.add(siteName.toString());
        }
        return result;
    }

    @Override
    protected String getSiteName(HttpServletRequest request) {
        String domainName = request.getServerName();
        if (this.mappings.containsKey(domainName)) {
            return (String)this.mappings.get(domainName);
        }
        logger.warn((Object)("No site mapping found for domain name " + domainName));
        return null;
    }

    protected void loadMappings() throws CrafterException {
        Properties tmpMappings = new Properties();
        try {
            tmpMappings.load(this.mappingsFile.getInputStream());
        }
        catch (IOException e) {
            throw new CrafterException("Unable to load domain name to site name mappings from " + this.mappingsFile, (Throwable)e);
        }
        Properties newMappings = new Properties();
        for (Map.Entry<Object, Object> entry : tmpMappings.entrySet()) {
            String trimmedKey = entry.getKey().toString().trim();
            String trimmedVal = entry.getValue().toString().trim();
            newMappings.setProperty(trimmedKey, trimmedVal);
        }
        logger.info((Object)("Domain name to site name mappings loaded from " + this.mappingsFile));
        this.mappings = newMappings;
    }
}

