/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyResourceLoader;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.core.service.ContentStoreService;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformationEngine;
import org.craftercms.engine.exception.SiteContextCreationException;
import org.craftercms.engine.macro.MacroResolver;
import org.craftercms.engine.scripting.ScriptFactory;
import org.craftercms.engine.scripting.ScriptJobResolver;
import org.craftercms.engine.scripting.impl.GroovyScriptFactory;
import org.craftercms.engine.service.PreviewOverlayCallback;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.SchedulingUtils;
import org.craftercms.engine.util.config.impl.MultiConfigurationBuilder;
import org.craftercms.engine.util.groovy.ContentStoreGroovyResourceLoader;
import org.craftercms.engine.util.groovy.ContentStoreResourceConnector;
import org.craftercms.engine.util.quartz.JobContext;
import org.craftercms.engine.util.spring.ApacheCommonsConfigPropertySource;
import org.craftercms.engine.util.spring.ContentStoreResourceLoader;
import org.quartz.Scheduler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;

public class SiteContextFactory
implements ApplicationContextAware {
    public static final String DEFAULT_SITE_NAME_MACRO_NAME = "siteName";
    private static final Log logger = LogFactory.getLog(SiteContextFactory.class);
    protected String siteNameMacroName = "siteName";
    protected String storeType = "filesystem";
    protected String storeServerUrl = null;
    protected String username = null;
    protected String password = null;
    protected String rootFolderPath;
    protected String staticAssetsPath;
    protected String templatesPath;
    protected String restScriptsPath;
    protected String controllerScriptsPath;
    protected String[] configPaths;
    protected String[] applicationContextPaths;
    protected String groovyClassesPath;
    protected Map<String, Object> groovyGlobalVars;
    protected boolean cacheOn = true;
    protected int maxAllowedItemsInCache = 0;
    protected boolean ignoreHiddenFiles = true;
    protected ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory;
    protected UrlTransformationEngine urlTransformationEngine;
    protected PreviewOverlayCallback overlayCallback;
    protected ContentStoreService storeService;
    protected MacroResolver macroResolver;
    protected ApplicationContext mainApplicationContext;
    protected List<ScriptJobResolver> jobResolvers;

    public void setSiteNameMacroName(String siteNameMacroName) {
        this.siteNameMacroName = siteNameMacroName;
    }

    public void setStoreType(String storeType) {
        this.storeType = storeType;
    }

    public void setStoreServerUrl(String storeServerUrl) {
        this.storeServerUrl = storeServerUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Required
    public void setRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
    }

    @Required
    public void setStaticAssetsPath(String staticAssetsPath) {
        this.staticAssetsPath = staticAssetsPath;
    }

    @Required
    public void setTemplatesPath(String templatesPath) {
        this.templatesPath = templatesPath;
    }

    @Required
    public void setRestScriptsPath(String restScriptsPath) {
        this.restScriptsPath = restScriptsPath;
    }

    @Required
    public void setControllerScriptsPath(String controllerScriptsPath) {
        this.controllerScriptsPath = controllerScriptsPath;
    }

    @Required
    public void setConfigPaths(String[] configPaths) {
        this.configPaths = configPaths;
    }

    @Required
    public void setApplicationContextPaths(String[] applicationContextPaths) {
        this.applicationContextPaths = applicationContextPaths;
    }

    @Required
    public void setGroovyClassesPath(String groovyClassesPath) {
        this.groovyClassesPath = groovyClassesPath;
    }

    @Required
    public void setGroovyGlobalVars(Map<String, Object> groovyGlobalVars) {
        this.groovyGlobalVars = groovyGlobalVars;
    }

    public void setCacheOn(boolean cacheOn) {
        this.cacheOn = cacheOn;
    }

    public void setMaxAllowedItemsInCache(int maxAllowedItemsInCache) {
        this.maxAllowedItemsInCache = maxAllowedItemsInCache;
    }

    public void setIgnoreHiddenFiles(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    @Required
    public void setFreeMarkerConfigFactory(ObjectFactory<FreeMarkerConfig> freeMarkerConfigFactory) {
        this.freeMarkerConfigFactory = freeMarkerConfigFactory;
    }

    @Required
    public void setUrlTransformationEngine(UrlTransformationEngine urlTransformationEngine) {
        this.urlTransformationEngine = urlTransformationEngine;
    }

    public void setOverlayCallback(PreviewOverlayCallback overlayCallback) {
        this.overlayCallback = overlayCallback;
    }

    @Required
    public void setStoreService(ContentStoreService storeService) {
        this.storeService = storeService;
    }

    @Required
    public void setMacroResolver(MacroResolver macroResolver) {
        this.macroResolver = macroResolver;
    }

    @Required
    public void setJobResolvers(List<ScriptJobResolver> jobResolvers) {
        this.jobResolvers = jobResolvers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.mainApplicationContext = applicationContext;
    }

    public SiteContext createContext(String siteName) {
        Map<String, String> macroValues = Collections.singletonMap(this.siteNameMacroName, siteName);
        String resolvedRootFolderPath = this.macroResolver.resolveMacros(this.rootFolderPath, macroValues);
        Context context = this.storeService.createContext(this.storeType, this.storeServerUrl, this.username, this.password, resolvedRootFolderPath, this.cacheOn, this.maxAllowedItemsInCache, this.ignoreHiddenFiles);
        try {
            SiteContext siteContext = new SiteContext();
            siteContext.setStoreService(this.storeService);
            siteContext.setSiteName(siteName);
            siteContext.setContext(context);
            siteContext.setStaticAssetsPath(this.staticAssetsPath);
            siteContext.setTemplatesPath(this.templatesPath);
            siteContext.setFreeMarkerConfig((FreeMarkerConfig)this.freeMarkerConfigFactory.getObject());
            siteContext.setUrlTransformationEngine(this.urlTransformationEngine);
            siteContext.setOverlayCallback(this.overlayCallback);
            siteContext.setRestScriptsPath(this.restScriptsPath);
            siteContext.setControllerScriptsPath(this.controllerScriptsPath);
            String[] resolvedConfigPaths = new String[this.configPaths.length];
            for (int i = 0; i < this.configPaths.length; ++i) {
                resolvedConfigPaths[i] = this.macroResolver.resolveMacros(this.configPaths[i], macroValues);
            }
            String[] resolvedAppContextPaths = new String[this.applicationContextPaths.length];
            for (int i = 0; i < this.applicationContextPaths.length; ++i) {
                resolvedAppContextPaths[i] = this.macroResolver.resolveMacros(this.applicationContextPaths[i], macroValues);
            }
            ContentStoreResourceLoader resourceLoader = new ContentStoreResourceLoader(siteContext);
            HierarchicalConfiguration config = this.getConfig(siteContext, resolvedConfigPaths, (ResourceLoader)resourceLoader);
            URLClassLoader classLoader = this.getClassLoader(siteContext);
            ScriptFactory scriptFactory = this.getScriptFactory(siteContext, classLoader);
            ConfigurableApplicationContext appContext = this.getApplicationContext(siteContext, classLoader, config, resolvedAppContextPaths, (ResourceLoader)resourceLoader);
            siteContext.setConfigPaths(resolvedConfigPaths);
            siteContext.setApplicationContextPaths(resolvedAppContextPaths);
            siteContext.setGroovyClassesPath(this.groovyClassesPath);
            siteContext.setScriptFactory(scriptFactory);
            siteContext.setConfig(config);
            siteContext.setApplicationContext(appContext);
            siteContext.setClassLoader(classLoader);
            Scheduler scheduler = this.scheduleJobs(siteContext);
            siteContext.setScheduler(scheduler);
            return siteContext;
        }
        catch (Exception e) {
            this.storeService.destroyContext(context);
            throw e;
        }
    }

    protected HierarchicalConfiguration getConfig(SiteContext siteContext, String[] configPaths, ResourceLoader resourceLoader) {
        MultiConfigurationBuilder builder = new MultiConfigurationBuilder(configPaths, resourceLoader);
        try {
            return (HierarchicalConfiguration)builder.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new SiteContextCreationException("Unable to load configuration for site '" + siteContext.getSiteName() + "'", e);
        }
    }

    protected URLClassLoader getClassLoader(SiteContext siteContext) {
        ContentStoreGroovyResourceLoader resourceLoader = new ContentStoreGroovyResourceLoader(siteContext, this.groovyClassesPath);
        GroovyClassLoader classLoader = new GroovyClassLoader(this.getClass().getClassLoader());
        classLoader.setResourceLoader((GroovyResourceLoader)resourceLoader);
        return classLoader;
    }

    protected ConfigurableApplicationContext getApplicationContext(SiteContext siteContext, URLClassLoader classLoader, HierarchicalConfiguration config, String[] applicationContextPaths, ResourceLoader resourceLoader) {
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            for (String path : applicationContextPaths) {
                Resource resource = resourceLoader.getResource(path);
                if (!resource.exists()) continue;
                resources.add(resource);
            }
            if (CollectionUtils.isNotEmpty(resources)) {
                GenericApplicationContext appContext = new GenericApplicationContext(this.mainApplicationContext);
                appContext.setClassLoader((ClassLoader)classLoader);
                if (config != null) {
                    MutablePropertySources propertySources = appContext.getEnvironment().getPropertySources();
                    propertySources.addFirst((PropertySource)new ApacheCommonsConfigPropertySource("siteConfig", (Configuration)config));
                }
                XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
                reader.setValidationMode(3);
                for (Resource resource : resources) {
                    reader.loadBeanDefinitions(resource);
                }
                appContext.refresh();
                logger.info((Object)("Application context loaded for site '" + siteContext.getSiteName() + "'"));
                return appContext;
            }
            return null;
        }
        catch (Exception e) {
            throw new SiteContextCreationException("Unable to load application context for site '" + siteContext.getSiteName() + "'", e);
        }
    }

    protected ScriptFactory getScriptFactory(SiteContext siteContext, URLClassLoader classLoader) {
        return new GroovyScriptFactory(new ContentStoreResourceConnector(siteContext), classLoader, this.groovyGlobalVars);
    }

    protected Scheduler scheduleJobs(SiteContext siteContext) {
        String siteName = siteContext.getSiteName();
        try {
            ArrayList<JobContext> allJobContexts = new ArrayList<JobContext>();
            for (ScriptJobResolver jobResolver : this.jobResolvers) {
                List<JobContext> jobContexts = jobResolver.resolveJobs(siteContext);
                if (!CollectionUtils.isNotEmpty(jobContexts)) continue;
                allJobContexts.addAll(jobContexts);
            }
            if (CollectionUtils.isNotEmpty(allJobContexts)) {
                Scheduler scheduler = SchedulingUtils.createScheduler(siteName + "_scheduler");
                for (JobContext jobContext : allJobContexts) {
                    scheduler.scheduleJob(jobContext.getDetail(), jobContext.getTrigger());
                    logger.info((Object)("Scheduled job: " + jobContext + " for site '" + siteName + "'"));
                }
                scheduler.start();
                return scheduler;
            }
        }
        catch (Exception e) {
            throw new SiteContextCreationException("Unable to schedule jobs for site '" + siteName + "'", e);
        }
        return null;
    }
}

