/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.service.context.SiteContextFactory;
import org.springframework.beans.factory.annotation.Required;

public class SiteContextManager {
    private static final Log logger = LogFactory.getLog(SiteContextManager.class);
    protected Lock lock = new ReentrantLock();
    protected Map<String, SiteContext> contextRegistry = new ConcurrentHashMap<String, SiteContext>();
    protected SiteContextFactory contextFactory;
    protected SiteContextFactory fallbackContextFactory;

    public Lock getLock() {
        return this.lock;
    }

    @Required
    public void setContextFactory(SiteContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Required
    public void setFallbackContextFactory(SiteContextFactory fallbackContextFactory) {
        this.fallbackContextFactory = fallbackContextFactory;
    }

    @PreDestroy
    public void destroy() {
        this.destroyAllContexts();
        logger.info((Object)"All site contexts have been destroyed");
    }

    public Collection<SiteContext> listContexts() {
        return this.contextRegistry.values();
    }

    public SiteContext createContext(String siteName, boolean fallback) {
        return this.getContext(siteName, fallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SiteContext getContext(String siteName, boolean fallback) {
        SiteContext siteContext = this.contextRegistry.get(siteName);
        if (siteContext == null) {
            this.lock.lock();
            try {
                siteContext = this.contextRegistry.get(siteName);
                if (siteContext == null) {
                    logger.info((Object)"==================================================");
                    logger.info((Object)("<Creating site context: " + siteName + ">"));
                    logger.info((Object)"==================================================");
                    if (fallback) {
                        siteContext = this.fallbackContextFactory.createContext(siteName);
                        siteContext.setFallback(true);
                    } else {
                        siteContext = this.contextFactory.createContext(siteName);
                    }
                    this.contextRegistry.put(siteName, siteContext);
                    logger.info((Object)("Site context created: " + siteContext));
                    logger.info((Object)"==================================================");
                    logger.info((Object)("</Creating site context: " + siteName + ">"));
                    logger.info((Object)"==================================================");
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return siteContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyContext(String siteName) {
        this.lock.lock();
        try {
            SiteContext siteContext = this.contextRegistry.remove(siteName);
            if (siteContext != null) {
                siteContext.destroy();
                logger.info((Object)("Site context destroyed: " + siteContext));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAllContexts() {
        this.lock.lock();
        try {
            Iterator<SiteContext> iter = this.contextRegistry.values().iterator();
            while (iter.hasNext()) {
                SiteContext siteContext = iter.next();
                siteContext.destroy();
                logger.info((Object)("Site context destroyed: " + siteContext));
                iter.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

