/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.service.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.craftercms.engine.service.context.AbstractSiteContextResolver;
import org.springframework.beans.factory.annotation.Required;

public class StaticMappingsSiteContextResolver
extends AbstractSiteContextResolver {
    private static final Log logger = LogFactory.getLog(StaticMappingsSiteContextResolver.class);
    private Map<String, String> mappings;

    @Required
    public void setMappings(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    @Override
    protected Collection<String> getSiteList() {
        return new LinkedHashSet<String>(this.mappings.values());
    }

    @Override
    protected String getSiteName(HttpServletRequest request) {
        String domainName = request.getServerName();
        if (this.mappings.containsKey(domainName)) {
            return this.mappings.get(domainName);
        }
        logger.warn((Object)("No site mapping found for domain name " + domainName));
        return null;
    }
}

