/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.craftercms.engine.targeting.impl.AbstractTargetIdManager;
import org.craftercms.engine.util.config.TargetingProperties;
import org.springframework.context.i18n.LocaleContextHolder;

public class LocaleTargetIdManager
extends AbstractTargetIdManager {
    @Override
    public String getCurrentTargetId() throws IllegalStateException {
        Locale currentLocale = LocaleContextHolder.getLocale();
        if (currentLocale != null) {
            return currentLocale.toString();
        }
        throw new IllegalStateException("No locale associated with the current thread");
    }

    @Override
    public List<String> getAvailableTargetIds() {
        Object[] availableTargetIds = TargetingProperties.getAvailableTargetIds();
        if (ArrayUtils.isEmpty((Object[])availableTargetIds)) {
            List availableLocales = LocaleUtils.availableLocaleList();
            ArrayList<String> availableLocaleStrs = new ArrayList<String>(availableLocales.size());
            for (Locale locale : availableLocales) {
                availableLocaleStrs.add(locale.toString());
            }
            return availableLocaleStrs;
        }
        return Arrays.asList(availableTargetIds);
    }
}

