/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.targeting.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.targeting.impl.AbstractTargetedUrlStrategy;

public class TargetedUrlByFolderStrategy
extends AbstractTargetedUrlStrategy {
    public static final String TARGETED_URL_REGEX_FORMAT = "^/?(%s)(/.+)?$";
    public static final int TARGET_ID_GROUP = 1;
    public static final int SUFFIX_GROUP = 2;

    @Override
    public String toTargetedUrl(String url) {
        Matcher matcher = this.matchUrl(url);
        if (matcher != null) {
            return url;
        }
        String targetId = this.targetIdManager.getCurrentTargetId();
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        return "/" + targetId + url;
    }

    @Override
    public String buildTargetedUrl(String prefix, String targetId, String suffix) {
        String targetedUrl = "";
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            targetedUrl = UrlUtils.appendUrl((String)targetedUrl, (String)prefix);
        }
        if (StringUtils.isNotEmpty((CharSequence)targetId)) {
            targetedUrl = UrlUtils.appendUrl((String)targetedUrl, (String)targetId);
        }
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            targetedUrl = UrlUtils.appendUrl((String)targetedUrl, (String)suffix);
        }
        targetedUrl = StringUtils.prependIfMissing((String)targetedUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return targetedUrl;
    }

    @Override
    protected String getPrefix(Matcher matcher) {
        return null;
    }

    @Override
    protected String getTargetId(Matcher matcher) {
        return matcher.group(1);
    }

    @Override
    protected String getSuffix(Matcher matcher) {
        return matcher.group(2);
    }

    @Override
    protected Pattern getTargetedUrlPattern() {
        String availableTargetIds = StringUtils.join(this.targetIdManager.getAvailableTargetIds(), (char)'|');
        String targetedUrlByFilePattern = String.format(TARGETED_URL_REGEX_FORMAT, availableTargetIds);
        return Pattern.compile(targetedUrlByFilePattern);
    }
}

