/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.url;

import org.apache.commons.lang3.StringUtils;
import org.craftercms.core.exception.UrlTransformationException;
import org.craftercms.core.service.CachingOptions;
import org.craftercms.core.service.Context;
import org.craftercms.core.url.UrlTransformer;
import org.craftercms.core.util.UrlUtils;
import org.craftercms.engine.targeting.TargetedUrlStrategy;
import org.craftercms.engine.util.TargetingUtils;
import org.craftercms.engine.util.config.TargetingProperties;
import org.springframework.beans.factory.annotation.Required;

public class ToTargetedUrlTransformer
implements UrlTransformer {
    protected TargetedUrlStrategy targetedUrlStrategy;

    @Required
    public void setTargetedUrlStrategy(TargetedUrlStrategy targetedUrlStrategy) {
        this.targetedUrlStrategy = targetedUrlStrategy;
    }

    public String transformUrl(Context context, CachingOptions cachingOptions, String url) throws UrlTransformationException {
        String rootFolder;
        if (TargetingProperties.isTargetingEnabled() && StringUtils.isNotEmpty((CharSequence)(rootFolder = TargetingUtils.getMatchingRootFolder(url)))) {
            String relativeUrl = StringUtils.substringAfter((String)url, (String)rootFolder);
            String targetedUrl = this.targetedUrlStrategy.toTargetedUrl(relativeUrl);
            return UrlUtils.appendUrl((String)rootFolder, (String)targetedUrl);
        }
        return url;
    }
}

