/*
 * Decompiled with CFR 0.152.
 */
package org.craftercms.engine.util;

import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.craftercms.commons.http.HttpUtils;
import org.craftercms.engine.model.SiteItem;
import org.craftercms.engine.service.context.SiteContext;
import org.craftercms.engine.util.spring.ApplicationContextAccessor;
import org.craftercms.profile.api.Profile;
import org.craftercms.security.authentication.Authentication;
import org.craftercms.security.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.i18n.LocaleContextHolder;

public class GroovyUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(GroovyUtils.class);
    public static final String VARIABLE_APPLICATION = "application";
    public static final String VARIABLE_REQUEST = "request";
    public static final String VARIABLE_RESPONSE = "response";
    public static final String VARIABLE_PARAMS = "params";
    public static final String VARIABLE_HEADERS = "headers";
    public static final String VARIABLE_COOKIES = "cookies";
    public static final String VARIABLE_SESSION = "session";
    public static final String VARIABLE_LOGGER = "logger";
    public static final String VARIABLE_LOCALE = "locale";
    public static final String VARIABLE_MODEL = "model";
    public static final String VARIABLE_CRAFTER_MODEL = "crafterModel";
    public static final String VARIABLE_AUTH = "authentication";
    public static final String VARIABLE_PROFILE = "profile";
    public static final String VARIABLE_SITE_CONFIG = "siteConfig";
    public static final String VARIABLE_FILTER_CHAIN = "filterChain";
    public static final String VARIABLE_APPLICATION_CONTEXT = "applicationContext";

    private GroovyUtils() {
    }

    public static void addCommonVariables(Map<String, Object> variables, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        variables.put(VARIABLE_APPLICATION, servletContext);
        variables.put(VARIABLE_REQUEST, request);
        variables.put(VARIABLE_RESPONSE, response);
        if (request != null) {
            variables.put(VARIABLE_PARAMS, HttpUtils.createRequestParamsMap((HttpServletRequest)request));
            variables.put(VARIABLE_HEADERS, HttpUtils.createHeadersMap((HttpServletRequest)request));
            variables.put(VARIABLE_COOKIES, HttpUtils.createCookiesMap((HttpServletRequest)request));
            variables.put(VARIABLE_SESSION, request.getSession(false));
        } else {
            variables.put(VARIABLE_PARAMS, null);
            variables.put(VARIABLE_HEADERS, null);
            variables.put(VARIABLE_COOKIES, null);
            variables.put(VARIABLE_SESSION, null);
        }
        variables.put(VARIABLE_LOGGER, LOGGER);
        variables.put(VARIABLE_LOCALE, LocaleContextHolder.getLocale());
        GroovyUtils.addSiteConfigVariable(variables);
    }

    public static void addModelVariable(Map<String, Object> variables, Object model) {
        variables.put(VARIABLE_MODEL, model);
    }

    public static void addCrafterModelVariable(Map<String, Object> variables, SiteItem crafterModel) {
        variables.put(VARIABLE_CRAFTER_MODEL, crafterModel);
    }

    public static void addSecurityVariables(Map<String, Object> variables) {
        Authentication auth = SecurityUtils.getCurrentAuthentication();
        Profile profile = null;
        if (auth != null) {
            profile = auth.getProfile();
        }
        variables.put(VARIABLE_AUTH, auth);
        variables.put(VARIABLE_PROFILE, profile);
    }

    public static void addSiteConfigVariable(Map<String, Object> variables) {
        SiteContext siteContext = SiteContext.getCurrent();
        HierarchicalConfiguration config = null;
        if (siteContext != null) {
            config = siteContext.getConfig();
        }
        variables.put(VARIABLE_SITE_CONFIG, config);
    }

    public static void addFilterChainVariable(Map<String, Object> variables, FilterChain filterChain) {
        variables.put(VARIABLE_FILTER_CHAIN, filterChain);
    }

    public static void addJobVariables(Map<String, Object> variables) {
        SiteContext siteContext = SiteContext.getCurrent();
        if (siteContext != null && siteContext.getApplicationContext() != null) {
            ApplicationContextAccessor appContext = new ApplicationContextAccessor();
            appContext.setApplicationContext((ApplicationContext)siteContext.getApplicationContext());
            variables.put(VARIABLE_APPLICATION_CONTEXT, appContext);
        }
        variables.put(VARIABLE_LOGGER, LOGGER);
        GroovyUtils.addSiteConfigVariable(variables);
    }
}

